package fr.irisa.cairn.jnimap.isl.jni.extra;

import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;

public class ISLLexNextTools {
	
	private static int log2(int l) {
		int i = 0; 
		while ((l = l/2)>0) i++;
		return i;
	}
	
	public static JNIISLMap lexNextPower(JNIISLSet dom, int depth, int power) {
		int i;
		
		//compute next
		JNIISLMap current = lexNext(dom,depth);

		int size = log2(power)+1;
		JNIISLMap[] ms = new JNIISLMap[size];
		for (i = 0; i < size; i++) {
			ms [i] = null;
		}
		ms[0] = current.copy();
		
		int log = 2;
		while(log<=power) {
			JNIISLMap current_copy = current.copy();
			current = JNIISLMap.applyRange(current_copy, current).makeDisjoint();
			ms[log2(log)] = current.copy();
			log=log*2;
		}
		log /= 2;
		int newpower = power - log;
		//compute next^power using previously built nexts.
		for (i = log2(log)-1; i >= 0 ; i--) {
			int p = newpower - (int)Math.pow(2, i);
			if (p >= 0) { 
				newpower = p;
				log += (i == 0)?1:(i*2);
				current = JNIISLMap.applyRange(ms[i], current);
				ms[i] = null;
			} 
		}
		current = current.coalesce().makeDisjoint();
		
		return current;
	}
	public static JNIISLMap lexNext(JNIISLSet dom, int nbInnerLoop) {
		JNIISLMap map = JNIISLMap.fromDomainAndRange(dom.copy(), dom.copy());
		JNIISLMap lt = JNIISLMap.lexLT(dom.getSpace());
		
		JNIISLMap nxt = null;
		int nb = lt.getNumberOfBasicMap();
		int i;
		for (i = nb-1; i >= nb-nbInnerLoop; i--) {
			JNIISLMap succs = JNIISLMap.fromBasicMap(lt.getBasicMapAt(i));
			JNIISLMap lexMin = JNIISLMap.intersect(map, succs).makeDisjoint().lexMin();
			if (nxt == null) {
				nxt = lexMin;
			} else {
				nxt = JNIISLMap.union(nxt, lexMin);
			}
			JNIISLSet remain = JNIISLSet.substract(dom.copy(),nxt.copy().getDomain());
			map = JNIISLMap.fromDomainAndRange(remain,dom.copy());
		}
		return nxt;
	}
}
