
package fr.irisa.cairn.jnimap.isl.jni.platform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class JNIISLAbstractPlatform {

	abstract public void loadPlatformLibraries();

	protected static final String DLL_PATH = "./.fr.irisa.cairn.jnimap.isl.temp";

	protected File loadLibToTemp(String libName, String tempName) {
		
		try {
			File dir = new File(DLL_PATH);
			dir.mkdirs();
			dir.deleteOnExit();
			
			InputStream inputStream = JNIISLAbstractPlatform.class.getResource("/"+libName).openStream();
			
			// Copy resource to filesystem in a temp folder with a unique name
			File temporaryDll = new File(dir.getAbsolutePath()+"/"+tempName);
			FileOutputStream outputStream = new FileOutputStream(temporaryDll);
			byte[] array = new byte[8192];
			int read = 0;
			while ( (read = inputStream.read(array)) > 0)
				outputStream.write(array, 0, read);
			outputStream.close();  
	
			// Delete on exit the dll
			temporaryDll.deleteOnExit();
			
			return temporaryDll;
		} catch (Exception e) {
			System.out.println(libName);
			e.printStackTrace();
			throw new RuntimeException("Could not load library : " + libName);
		}
	}
	
}
