
package fr.irisa.cairn.jnimap.isl.jni.platform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class JNIISLLinux_32 extends JNIISLAbstractPlatform{


	
	public void loadPlatformLibraries() {
	
		// Get input stream from jar resource
		String lib = "linux_32_libjniisl.so";
		try {
			//Copy the binding object file from jar to temporary location
			File JNIDLL = loadLibToTemp(lib, lib);
			//Copy other dynamic libraries from jar to temporary location

			//Loading ISL
			loadLibToTemp("ISL/ISL_linux_32","libisl.so.7");
			//Loading GMP
			loadLibToTemp("ISL/GMP_linux_32","libgmp.so.10");
			// Finally, load the dll
			System.load(JNIDLL.getAbsolutePath());
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException("Problem during narive library loding ISL:"+e.getMessage());
		}
	
	}
}
