
package fr.irisa.cairn.jnimap.isl.jni.platform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class JNIISLMacosx_64 extends JNIISLAbstractPlatform{


	
	public void loadPlatformLibraries() {
	
		// Get input stream from jar resource
		String lib = "macosx_64_libjniisl.so";
		try {
			//Copy the binding object file from jar to temporary location
			File JNIDLL = loadLibToTemp(lib, lib);
			//Copy other dynamic libraries from jar to temporary location

			//Loading ISL
			loadLibToTemp("ISL/ISL_macosx_64","libisl.7.dylib");
			//Loading GMP
			loadLibToTemp("ISL/GMP_macosx_64","libgmp.10.dylib");
			// Finally, load the dll
			System.load(JNIDLL.getAbsolutePath());
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException("Problem during narive library loding ISL:"+e.getMessage());
		}
	
	}
}
