package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import java.util.List;

import junit.framework.TestCase;
import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLPoint;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;

public class ISLJNITestEnumeration extends TestCase {

	public void testSet1() {
		int size = 32;
		JNIISLSet set = ISLFactory.islSet("{ [i] : 0 <= i < "+size+"}");
		int n = set.getNbPoints();
		assertEquals(size, n);
	}

	public void testSet2() {
		int size = 15;
		JNIISLSet set = ISLFactory.islSet("{ [i,j] : 0 <= i < "+size+" and 0 <= j < "+size+"}");
		int n = set.getNbPoints();
		assertEquals(size*size, n);
	}

	public void testSet3() {
		int size = 99;
		JNIISLSet set = ISLFactory.islSet("{ [i,j] : 0 <= i < "+size+" and 0 <= j < i}");
		int n = set.getNbPoints();
		assertEquals((size*(size-1))/2, n);
	}

	public void testList1() {
		JNIISLSet set = ISLFactory.islSet("[N] -> { [i] : 0 <= i < N and N = 8}");
		
		List<JNIISLPoint> list = set.getPoints();
		System.out.println(list);
	}
}
