package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import static fr.irisa.cairn.jnimap.isl.jni.ISLFactory.islMap;
import static fr.irisa.cairn.jnimap.isl.jni.ISLFactory.islSet;
import junit.framework.TestCase;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDim;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSpace;

public class ISLMapTest extends TestCase {
	
	static JNIISLSet set0 = islSet("{ S0[i,j,k] : 0<=i<8 & 0<=j<8 & k=8i+j }");
	static JNIISLSet set1 = islSet("{ S1[i,j,k] : 0<=i<8 & 0<=j<8 & k=8i+j+2 }");
	static JNIISLSet set2 = islSet("{ S2[i,j,k] : 0<=i<8 & 0<=j<8 & k=8i+j }");

	static JNIISLMap map0 = islMap("{ S1[i,j] -> [k] : 0<=i<8 & 0<=j<8 & k=8i+j }");
	static JNIISLMap map1 = islMap("{ S2[i,j] -> [k] : 0<=i<8 & 0<=j<8 & k=8i+j+2 }");
	static JNIISLMap map2 = islMap("{ S1[i,j] -> [k] : 0<=i<8 & 0<=j<8 & k=8i+j }");

	public static void testBijective() {

		JNIISLSet S2S1  = JNIISLSet.intersect(map1.copy().getRange(), map2.copy().getRange());
		JNIISLSet copy = S2S1.copy();
		System.out.println(copy);
		JNIISLMap reverse = map1.copy().reverse();
		JNIISLSet apply = copy.apply(reverse);
		System.out.println(apply);
		//S2S1.copy().apply(S2.copy().reverse());
//		int bijective = juggling.isBijective();
//		System.out.println(juggling+" bijective='"+bijective+"'");
//		assert(bijective!=0);
//		JNIISLMap reverse = juggling.copy().reverse();
//		System.out.println(reverse);
//		JNIISLMap l = reverse.copy().projectOut(JNIISLDimType.isl_dim_out, 0, 1);
//		System.out.println(l);

//		JNIISLMap nonjuggling = islMap("{ [i,j] -> [k] : 0<=i<12 & 0<=j<9 & k=8i+j}");
//		System.out.println(nonjuggling+" bijective='"+nonjuggling.isBijective()+"'");
//
//		JNIISLMap nonjuggling2 = islMap("{ [i,j] -> [i',j'] :  i'=i & j'=j}");
//		System.out.println(nonjuggling2+" bijective='"+nonjuggling2.isBijective()+"'");
	}
	
	public  static void testLexicographic() {
		//JNIISLMap map = JNIISLMap.fromDomainAndRange(set0.copy(), set0.copy());
		JNIISLSpace dimensions = set0.getSpace();
		
		System.out.println("dim=("+dimensions+")");
		//dimensions = dimensions.map();
		System.out.println(dimensions);
		
		JNIISLMap local = JNIISLMap.lexGTFirst(dimensions,1);
		System.out.println(local);
		local = JNIISLMap.lexGTFirst(dimensions,2);
		System.out.println(local);
		local = JNIISLMap.lexGTFirst(dimensions,3);
		System.out.println(local);

	}


	/*
	public static void testRenameBasicMap() {
		JNIISLBasicMap bmap1 = ISLFactory.islMap("[Q, N] -> { [c, j] -> [q, r] :  }").getBasicMapAt(0);
		
		JNIISLBasicMap bmap2 = ISLFactory.islMap("[M,N] -> { [i,j] -> [a,b] : }").getBasicMapAt(0);
		System.out.println(bmap2.copy());
		bmap2 = bmap2.setDimensionName(JNIISLDimType.isl_dim_param, 0, "P");
		System.out.println(bmap2.copy());
		bmap2 = bmap2.setDimensionName(JNIISLDimType.isl_dim_set, 0, "q");
		System.out.println(bmap2.copy());
		bmap2 = bmap2.setDimensionName(JNIISLDimType.isl_dim_out, 1, "r");
		System.out.println(bmap2.copy());
		bmap2 = bmap2.setDimensionName(JNIISLDimType.isl_dim_in, 0, "c");
		System.out.println(bmap2.copy());
		
		assertEquals(1,bmap1.getDimensions().isCompatibleWith(bmap2.getDimensions()));
	}


	public static void testRenameMap() {
		JNIISLMap bmap1 = ISLFactory.islMap("[Q, N] -> { [c, j] -> [q, r] : c = q and j = r }");
		
		JNIISLMap bmap2 = ISLFactory.islMap("[M,N] -> { [i,j] -> [a,b] : i = a and j = b }");
		System.out.println(bmap2.copy());
		bmap2 = bmap2.setDimensionName(JNIISLDimType.isl_dim_param, 0, "P");
		System.out.println(bmap2.copy());
		bmap2 = bmap2.setDimensionName(JNIISLDimType.isl_dim_set, 0, "q");
		System.out.println(bmap2.copy());
		bmap2 = bmap2.setDimensionName(JNIISLDimType.isl_dim_out, 1, "r");
		System.out.println(bmap2.copy());
		bmap2 = bmap2.setDimensionName(JNIISLDimType.isl_dim_in, 0, "c");
		System.out.println(bmap2.copy());
		
		assertEquals(1,bmap1.getDimensions().isCompatibleWith(bmap2.getDimensions()));
	}
	
	public static void testRenameBasicMap_advanced() {
		JNIISLBasicMap m = islMap("{ [i,j] -> [k] : 0<=i<8 & 0<=j<8 & k=8i+j }").getBasicMapAt(0);
		System.out.println(m.copy());
		JNIISLBasicMap m2 = islMap("{ [t,j] -> [k] : 0<=t<8 & 0<=j<8 & k=8t+j }").getBasicMapAt(0);
		System.out.println(m2.copy());
		m2 = m2.setDimensionName(JNIISLDimType.isl_dim_in, 0, "i");
		System.out.println(m2);
	}
	
	public static void testRenameMap_advanced() {
		JNIISLMap m = islMap("{ S1[i,j] -> [k] : 0<=i<8 & 0<=j<8 & k=8i+j }");
		System.out.println(m.copy());
		JNIISLMap m2 = islMap("{ S1[t,j] -> [k] : 0<=t<8 & 0<=j<8 & k=8t+j }");
		System.out.println(m2.copy());
		m2 = m2.setDimensionName(JNIISLDimType.isl_dim_in, 0, "i");
		System.out.println(m2.copy());
	}
	//*/
}
