package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import static fr.irisa.cairn.jnimap.isl.jni.ISLFactory.islPWQPolynomial;
import junit.framework.TestCase;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDim;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDimType;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLFold;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLPWQPolynomial;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLPWQPolynomialFold;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLQPolynomial;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLQPolynomialFold;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSpace;

public class ISLPolynomialTest extends TestCase{


	public static void testQPolynomialsConstruction() {
		JNIISLSpace allocSet = JNIISLSpace.allocSet(1, 1);
		
		JNIISLQPolynomial p = new JNIISLQPolynomial(allocSet);
		System.out.println(p);
		System.out.println("constant : "+p.isConstant());
		assertTrue(p.isConstant());

		p = new JNIISLQPolynomial(allocSet, 5, 6);
		System.out.println(p);
		System.out.println("constant : "+p.isConstant());
		assertTrue(p.isConstant());
		
		p = JNIISLQPolynomial.buildOne(allocSet.copy());
		System.out.println(p);
		System.out.println("constant : "+p.isConstant());
		assertTrue(p.isConstant());
		
		p = JNIISLQPolynomial.buildNAN(allocSet.copy());
		System.out.println(p);
		System.out.println("constant : "+p.isConstant());
		assertTrue(p.isConstant());
		
		p = JNIISLQPolynomial.buildInfinity(allocSet.copy());
		System.out.println(p);
		System.out.println("constant : "+p.isConstant());
		assertTrue(p.isConstant());
		
		p = JNIISLQPolynomial.buildNegInfinity(allocSet.copy());
		System.out.println(p);
		System.out.println("constant : "+p.isConstant());
		assertTrue(p.isConstant());
		
		p = new JNIISLQPolynomial(allocSet.copy(), JNIISLDimType.isl_dim_param, 0);
		System.out.println(p);
		System.out.println("constant : "+p.isConstant());
		assertFalse(p.isConstant());
		
		p = new JNIISLQPolynomial(allocSet.copy(), JNIISLDimType.isl_dim_set, 0);
		System.out.println(p);
		System.out.println("constant : "+p.isConstant());
		assertFalse(p.isConstant());
	}

	public static void testQPolynomials() {
		JNIISLSpace allocSet = JNIISLSpace.allocSet(1, 1);
		
		JNIISLQPolynomial p = new JNIISLQPolynomial(allocSet.copy(), 5, 6);
		p = p.scale(6);
		System.out.println(p);
		
		p = new JNIISLQPolynomial(allocSet.copy(), 5, 6);
		System.out.println(p);
		JNIISLQPolynomial p2 = new JNIISLQPolynomial(allocSet.copy(), 6, 1);
		p = p.mul(p2);
		System.out.println(p);
		
	}
	
	public static void testPWQPolynomial (){
		
		System.out.println("********* Polynomials *********");
		JNIISLPWQPolynomial P1 = islPWQPolynomial("[n] -> { [i, j] -> (n^2 + j^2*i^3) : j >= 0 and j <= i and i >= 1 and i <= -2 + n and n>=1 and n <= 16 }");
		System.out.println("P1 : "+P1);

		JNIISLPWQPolynomial P2 = islPWQPolynomial("[n] -> { [i, j] -> (i^4 + n^2 + j*i) : j >= i+1 and j <= -1 + n and i >= 1 and i <= -2 + n and n>=1 and  n <= 16 }");
		System.out.println("P2 : "+P2);

		System.out.println("********* Sum of Polynomials *********");
		JNIISLPWQPolynomial P3 = P1.add(P2);
		
		System.out.println("P3=P1+P2 : "+P3);
		
		System.out.println("********* Minima (iterative barvinok/bound.c)*********");
		
		JNIISLSpace dim = P3.getSpace().copy();
		System.out.println("dims : "+dim);
		
		long nvar = dim.getSize(JNIISLDimType.isl_dim_set);
		System.out.println("nvar : "+nvar);
		JNIISLQPolynomial qp =  P3.copy().getMin();
		System.out.println("qp: "+qp);
		qp.dropDim(JNIISLDimType.isl_dim_set, 0, nvar);
		dim = dim.drop(JNIISLDimType.isl_dim_set, 0, nvar);
		JNIISLSet set = JNIISLSet.buildUniverse(dim);
		JNIISLQPolynomialFold fold = new JNIISLQPolynomialFold(JNIISLFold.isl_fold_min, qp);
		System.out.println(fold);

		JNIISLPWQPolynomialFold pwFold = new JNIISLPWQPolynomialFold(JNIISLFold.isl_fold_min, set, fold);
		System.out.println(pwFold);

		pwFold = P3.bound(JNIISLFold.isl_fold_min);
		System.out.println(pwFold);
	}

	public static void testMin() {
		System.out.println("------------------------------------");
		System.out.println(islPWQPolynomial("[n] -> { (n^2 ) : n >= 1 and n <= 16 }").bound(JNIISLFold.isl_fold_max).getMax());
		System.out.println(islPWQPolynomial("[n] -> { (n^2 ) : n >= 1 and n <= 16 }").bound(JNIISLFold.isl_fold_max).getMin());
		System.out.println(islPWQPolynomial("[N] -> { (-9 + 3 * N) : 5N >= 4 && 2N < 1024}").bound(JNIISLFold.isl_fold_min).getMax());
		System.out.println(islPWQPolynomial("[N] -> { (-9 + 3 * N) : N >= 4 && N < 1024 }").bound(JNIISLFold.isl_fold_min).getMin());
	}
}









