package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import static fr.irisa.cairn.jnimap.isl.jni.ISLFactory.islSet;
import junit.framework.TestCase;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDimType;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;

public class ISLSetTest extends TestCase {

	public static void testMain() {
		
//		#### next^2_d_y ####
//		[M] -> {
//		 S[i, j] -> S[-1 + i, 2 + j] : i >= 2 and i <= -1 + M and j >= 0 and j <= -3 + M;
//		 S[i, -1 + M] -> S[i, 1] : i >= 2 and i <= -1 + M and M >= 2;
//		 S[i, -2 + M] -> S[i, 0] : i >= 2 and i <= -1 + M and M >= 2 
//		}
//		#### le ####
//		[M] -> {
//		 S[i, j] -> S[i', j'] : i' >= 1 + i;
//		 S[i, j] -> S[i, j'] : j' >= 1 + j 
//		}		

		JNIISLSet set1 = islSet("[M] -> { S[i, j] : i <= -1 + M and M >= 2 and i >= 0 and j >= 0 and j <= -1 + M and j <= M - i	}");
		System.out.println(set1.coalesce().lexMax());
		set1 = islSet("[M]->{ [i,j,i',j'] :  i >= 2 and i <= -2 + M and M >= 2 & j=M-1 & j'=1 & i=i'}");
		JNIISLSet set2= set1.copy().moveDims(JNIISLDimType.isl_dim_set, 2, JNIISLDimType.isl_dim_set, 3, 1);

		System.out.println(set1+"\n"+set2+"\n");
		

		//JNIISLSet orig = islSet("[N]->{ [i,j] : i >= 0 && i < N && j >= 0 && j < N-i}");
		/*JNIISLSet nopDom = islSet("[N]->{ [i,j] : i >= N-3 && i < N-1 && j > N -i && j <= N - i + 3}");
		
		JNIISLSet union = JNIISLSet.union(orig.copy(), nopDom.copy());
		System.out.println(union);
	*/	
		
//		JNIISLSet set = islSet("[N] -> { [i, j] : "+
//		 " i >= 0 and j >= 0 and j <= -5 + N - i "+
//		 " or i >= 0 and i <= -5 + N"+
//		 " or i >= 0 and i <= -4 + N"+
//		 " or i >= 0 and i <= -3 + N"+
//		 " or i >= 0 and i <= -4 + N"+
//		 " or N >= 3"+
//		 " or N >= 4 "+
//		"}");
//		
//		set = set.gist(orig).coalesce();
//		System.out.println(set);
		
		
		/*
		JNIISLSet existential =  
			islSet("[n] -> { [i,j] : exists (a = [i/10] : 0 <= i and i <= n and i - 10 a <= 6) and  exists (c  : 0 <= c <10 ) and i=10a+c and j=c}" );

		JNIISLSet set_b = islSet("[N,P]-> { [j,i] : j>= i  & j-N< 0  & i>= 0  & i-3< 0 | j>= i  & j> 15  & i>= 0  & i=3  }");
		
		set_b=existential;
		long nbdim = set_b.getNDim();
		JNIISLDim dims= set_b.getDimensions();
		set_b= set_b.alignDivs();
		System.out.println(dims.getSize(JNIISLDimType.isl_dim_param));
		System.out.println(dims.getSize(JNIISLDimType.isl_dim_in));
		
		System.out.println(set_b.toString(ISL_FORMAT.POLYLIB));
		System.out.println(set_b.toString(ISL_FORMAT.LATEX));
		System.out.println(set_b.toString(ISL_FORMAT.ISL));
		System.out.println(set_b.toString(ISL_FORMAT.OMEGA));
			
		
		int numberOfBasicSet = set_b.getNumberOfBasicSet();
		for(int i=0;i<numberOfBasicSet;i++) {
			System.out.println("BSET n�"+i);
			JNIISLBasicSet bset = set_b.getBasicSetAt(i);
			System.out.println("BasicSet :\n"+bset);
			System.out.println("Equalities :");
			JNIISLMatrix mat = bset.toEqualityMatrix(
					JNIISLDimType.isl_dim_out, 
					JNIISLDimType.isl_dim_div, 
					JNIISLDimType.isl_dim_param, 
					JNIISLDimType.isl_dim_cst);
			for(int k=0 ; k<mat.getNbRows();k++) {
				for(int m=0 ; m<mat.getNbCols();m++) {
					System.out.print(" "+mat.getAt(k, m));
				}
				System.out.println(" ");
			}
			System.out.println("Inequalities :");
			mat = bset.toInequalityMatrix(
					JNIISLDimType.isl_dim_out, 
					JNIISLDimType.isl_dim_div, 
					JNIISLDimType.isl_dim_param, 
					JNIISLDimType.isl_dim_cst);
			for(int k=0 ; k<mat.getNbRows();k++) {
				for(int m=0 ; m<mat.getNbCols();m++) {
					System.out.print(" "+mat.getAt(k, m));
				}
				System.out.println(" ");
			}
			
		}
	//*/
	}
	
	public void testComplement() {

		JNIISLSet set1 = islSet("[N] -> { S[i] : 0<=i<N }");
		JNIISLSet set1comp = set1.complement();
		System.out.println(set1comp+"\n");
	}
}
