package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import junit.framework.TestCase;
import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.ISLPrettyPrinter;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLBasicMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLBasicSet;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLConstraint;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;

public class ISLTestConstraints extends TestCase {
	
	public static void atestSimpleSet() {
		String stringDefinition = "{ [i] : 0 <= i && i < 8 }";
		JNIISLSet set = ISLFactory.islSet(stringDefinition);
		assertNotNull(set);
		int nbBset = set.getNumberOfBasicSet();
		assertEquals(1,nbBset);
		JNIISLBasicSet bset = set.getBasicSetAt(0);
		assertNotNull(bset);
		int nbConstraints = bset.getNumberOfConstraints();
		assertEquals(2,nbConstraints);
		
		//assume order in the list is order of appearance from left to right in string definition
		for (int i = 0; i < nbConstraints; i++) {
			JNIISLConstraint c = bset.getConstraintAt(i);
			System.out.println(ISLPrettyPrinter.asString(c));
			System.out.println(c.javaPrint());
			System.out.println(c.toString());
		}
	}

	public static void testBasicMap() {
		String stringDefinition = "[M] -> { [i] -> [a] : 0 <= i && i < 8 && i = a + 2 }";
		JNIISLBasicMap bmap = ISLFactory.islBasicMap(stringDefinition);
		assertNotNull(bmap);
		int nbConstraints = bmap.getNumberOfConstraints();
		assertEquals(3,nbConstraints);
		
		//assume order in the list is order of appearance from left to right in string definition
		for (int i = 0; i < nbConstraints; i++) {
			JNIISLConstraint c = bmap.getConstraintAt(i);
			System.out.println(ISLPrettyPrinter.asString(c));
			System.out.println(c.javaPrint());
			System.out.println(c.toString());
		}
	}
	
}
