package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import static fr.irisa.cairn.jnimap.isl.jni.ISLFactory.islMap;
import static fr.irisa.cairn.jnimap.isl.jni.ISLFactory.islSet;
import junit.framework.TestCase;
import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLBasicSet;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;
public class IslJNITest extends TestCase {
	


	public static void testProjectionExamples() {
		
		
		System.out.println("#############################################");
		System.out.println("   Projection examples ");
		System.out.println("#############################################");
		// projecting out the two indices
//		JNIISLSet set_b = islSet("[N,P]-> { [j,i] : j>= i  & j-N< 0  & i>= 0  & i-3< 0  }");
//		System.out.println("\nProjecting out i,j");
//		System.out.println(" => "+set_b.projectOut(JNIISLDimType.isl_dim_set, 0, 2));
//		System.out.println("Card ("+set_b+") => "+new JNIISLPWQPolynomial(set_b));
//		
//		
//		// projecting out the index j
//		set_b = islSet("[N,P]-> { [j,i] : j>= i  & j-N< 0  & i>= 0  & i-3< 0  }");
//		System.out.println("\nProjecting out j");
//		System.out.println(" => "+set_b.projectOut(JNIISLDimType.isl_dim_set, 0, 1));
//		System.out.println("Card ("+set_b+") => "+new JNIISLPWQPolynomial(set_b));
//		
//		// projecting out the index i
//		set_b = islSet("[N,P]-> { [j,i] : j>= i  & j-N< 0  & i>= 0  & i-3< 0  }");
//		System.out.println("\nProjecting out i");
//		System.out.println(set_b+" => "+set_b.projectOut(JNIISLDimType.isl_dim_set, 1, 1));
//		System.out.println("Card ("+set_b+") => "+new JNIISLPWQPolynomial(set_b));
//
//		// projecting out parameters N,M
//		set_b = islSet("[N,P]-> { [j,i] : j>= i  & j-N< 0  & i>= 0  & i-3< 0  }");
//		System.out.println(set_b.projectOut(JNIISLDimType.isl_dim_param, 0, 2));
//		System.out.println("Card ("+set_b+") => "+new JNIISLPWQPolynomial(set_b));
//
//		// projecting out parameters M
//		set_b = islSet("[N,P]-> { [j,i] : j>= i  & j-N< 0  & i>= 0  & i-3< 0  }");
//		System.out.println(set_b.projectOut(JNIISLDimType.isl_dim_param, 1, 1));
//		System.out.println("Card ("+set_b+") => "+new JNIISLPWQPolynomial(set_b));

	}
	
	public static void testMain() {

		
		JNIISLSet param = islSet("[PM,Q]->{[] : 0<PM and 0<Q}");
		JNIISLSet set = islSet("[P,Q]->{[i,j] : 0<=i<P and 0<=j<Q}");
		//JNIISLSet param_cp = param.copy().extend(2, 2);
		System.out.println(param);
		System.out.println(set);
		//System.out.println(JNIISLSet.intersect(param, set).gist(param_cp));
		System.out.println(set.polyhedralHull());
		
//		JNIISLMap map1 = islMap("[]->{[i,j] -> [i]}");
//		JNIISLMap map2 = islMap("[]->{[i] -> []}");
//		System.out.println(JNIISLMap.applyRange(map1, map2));
		
//		projectionExamples();
//		intersectUnionExamples();
//		
//		CoBTest();
//		
//		JNIISLSet set_a = islSet("[]->{[i] : i > 10 && i< 152}");
//		System.out.println(set_a);
//		
//		JNIISLMap map_a = islMap("{[i,j] -> [k] : k=8*i+j & 0<= k < 64 & 0 <= i < 8 & 0 <= j < 8}");
//		System.out.println(map_a);
//		JNIISLMap invmap_a  = map_a.copy().reverse();
//		
//		System.out.println("Testing polynomials");
//		JNIISLPWQPolynomial pa = new JNIISLPWQPolynomial(set_a);
//		System.out.println(pa);
//		
//		JNIISLSet map_b = islSet("[K] -> {[i,j] :  K=8*i+j & 0<= K < 64 & 0 <= i < 8 & 0 <= j < 8}");
//		System.out.println(map_b);
//		JNIISLSet invmap_b  = map_b.copy().lexMin();
//		
//		System.out.println("lexmin :"+invmap_b);

		//JNIISLMap map_a = islMap("{[i] -> [i,i] : 0 <= i < 8 }");

//		JNIISLMap lexMin = invmap_a.copy().lexMin();
//		System.out.println("lexmin ="+lexMin);
//		JNIISLMap lexMax = invmap_a.copy().lexMax();
//		System.out.println("lexmax ="+lexMax);
		
		//JNIISLMap map_b = map_a.computeDivs();
		//System.out.println(map_b);
		
//		basicMapTest();
//		basicSetTest();
		
	}
	
	public static void testCoBTest() {
		System.out.println("##########################");
		System.out.println("## Change of Base ");
		System.out.println("##########################");
		JNIISLSet set_a = islSet("[N,M]->{[i,j] : i < N & 0 < i & j < M & 0 < j}");
		System.out.println("## set : " +set_a);
		JNIISLMap map_a = islMap("[N,M]->{[i,j]->[i',j'] : i'=i & j'=i+j}");
		//JNIISLMap map_a = islMap("[N,M]->{[i,j]->[j,i] }");
		System.out.println("## transform :"+map_a );
		JNIISLMap reverse = map_a.copy().reverse();
		System.out.println("## reverse transform :"+reverse);
		JNIISLSet set_b = set_a.apply(map_a);
		System.out.println("## transformed set  :"+set_b );

	}

	public static void testIntersectUnionExamples() {
		System.out.println("## Intersect/Union example");
		JNIISLSet set_a = islSet("[N,P]-> { [j,i] : j>= i  & j-N< 0  & i>= 0  & i-3< 0  }");
		JNIISLSet set_b = islSet("[N,P]-> { [j,i] : j>= P  & j-N< 0  & i>= 0  & 2i-j+2*P< 0  }");
		System.out.println("a = "+set_a+";");
		System.out.println("b = "+set_b+";");
		System.out.println("a inter b = "+JNIISLSet .intersect(set_a.copy(), set_b.copy())+";");
		System.out.println("Hello!");
		set_a = islSet("[N,P]-> { [j,i] : j>= i  & j-N< 0  & i>= 0  & i-3< 0  }");
		System.out.println("Bye!");
		set_b = islSet("[N,P]-> { [j,i] : j>= P  & j-N< 0  & i>= 0  & 2i-j+2*P< 0  }");
		System.out.println("a = "+set_a+";");
		System.out.println("b = "+set_b+";");
		System.out.println("a union b = "+JNIISLSet .union(set_a, set_b)+";");
		
		
	}
	
	public static void testBasicMapTest() {
		System.out.println("## Testing map");
		JNIISLMap bmap_a = ISLFactory.islMap("{[i,j]->[k]}");
		System.out.println(bmap_a);
		System.out.println(bmap_a.computeDivs());
		System.out.println("## convex hull");
		System.out.println(bmap_a.copy().convexHull());
		System.out.println("## is empty ");
		System.out.println(bmap_a.isEmpty());
		System.out.println("## domain ");
		System.out.println(bmap_a.getDomain());
		System.out.println("## nbIn ");
		System.out.println(bmap_a.getNbIn());
		System.out.println("## nbOut");
		System.out.println(bmap_a.getNbOut());
		System.out.println("## nbParam ");
		System.out.println(bmap_a.getNbParam());
		System.out.println("## range");
		System.out.println(bmap_a.getRange());
		
	}
	
	public static void testBasicSetTest() {
		System.out.println("## Testing set");
		JNIISLSet bset_a = ISLFactory.islSet("[]->{[i] : 0<i & i < 10}");
		System.out.println(bset_a);
		System.out.println("## isEmpty");
		System.out.println(bset_a.isEmpty());
		System.out.println("## lexMin");
		System.out.println(bset_a.copy().lexMin());
		System.out.println("## lexMax");
		System.out.println(bset_a.copy().lexMax());
		System.out.println("## AffineHull");
		JNIISLBasicSet affineHull = bset_a.copy().affineHull();
		System.out.println(affineHull);
		//System.out.println(bset_a.copy().add(JNIISLDimType.isl_dim_in, 3));
//		System.out.println(bset_a.IslBasicSetNDim());
//		System.out.println(bset_a.IslBasicSetNParam());
//		System.out.println(bset_a.IslBasicSetTotalDim());
		
	}
}
