package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import junit.framework.TestCase;
import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDimType;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;

public class LiverangeTest extends TestCase {
	
	
//	final static String _prdg= " [M] -> { "+
//	"C[i0] -> C[j0] :" +
//	"0<= i0 <= M  and 0<= j0 <= M and j0=i0-3  "+ 
//	"}";
//
//	final static String _schedule= " [M] -> { "+
//	"C[i0] -> [c0 ] :"+ 
//		"c0=i0  "+
//	"}";
//
//	final static String _deltamap= " [M] -> { "+
//	"[i0, j0] -> [D0] :"+ 
//		"D0=j0-i0 "+
//	"}";

	final static String _dom= " [M] -> { [i0, i1] : 0<= i0 < M  and 0<= i1 < M }";

	final static String _prdg= " [M] -> { "+
	"[i0, i1] -> [j0, j1] :" +
	"0<= i0 < M  and 0<= i1 < M and 0<= j0 < M and 0<= j1 < M  and j0=i0 and j1=i1-1 or "+ 
	"0<= i0 < M  and 0<= i1 < M and 0<= j0 < M and 0<= j1 < M  and j0=i0 and j1=i1-1 "+ 
	"}";

	final static String _schedule= " [M] -> { "+
	"[i0, i1] -> [c0,c1 ] :"+ 
		"c0=i1 & c1=i0 "+
	"}";

	final static String _deltamap= " [M] -> { "+
	"[i0, i1,j0, j1] -> [D0,D1] :"+ 
		"D0=j0-i0 and D1=j1-i1 "+
	"}";

	public static void testLiveRange() {
		
		
		/**
		 
		 
		 CS=[M] -> { 
		 	[c0, c1, 1 + c0, c1'] : c1' >= 0 and c1' <= M and c0 >= 0 and c0 <= -1 + M and c1' <= c1; 
		 	[c0, c1, c0, c1'] : (c1' >= 0 and c1' <= M and c0 >= 1 and c0 <= M and c1' >= 1 + c1) or (c1 >= 0 and c1 <= M and c0 >= 1 and c0 <= M and c1' <= -1 + c1); 
		 	[c0, c1, -1 + c0, c1'] : c1 >= 0 and c1 <= M and c0 >= 1 and c0 <= M and c1' >= c1 
		 }
		 	
		DS=[M] -> { [1, D1] : D1 <= 0 and M >= 1; [0, D1] : (D1 >= 1 and M >= 1) or (D1 <= -1 and M >= 1); [-1, D1] : D1 >= 0 and M >= 1 }
		 */

		// 
		JNIISLSet dom= ISLFactory.islSet(_dom);
		JNIISLSet set = ISLFactory.islSet("[M] -> { C[i0, i1] : 0<= i0 <= M  and 0<= i1 <= M }");
		JNIISLMap map = ISLFactory.islMap("[M] -> { C[i0, i1] -> A[i0-i1] }");
		System.out.println(set.apply(map));

		
		JNIISLMap prdg = ISLFactory.islMap(_prdg);
		JNIISLMap schedule = ISLFactory.islMap(_schedule);
		
		JNIISLMap sched_prdg = JNIISLMap.applyDomain(prdg.copy(), schedule.copy());
		sched_prdg = JNIISLMap.applyRange(sched_prdg.copy(), schedule.copy());
		
		System.out.println("Scheduled PRDG="+sched_prdg);

		
		JNIISLMap lastUse = sched_prdg.copy().reverse().lexMax();
		
		
		System.out.println("lastUse="+lastUse);

		// i lexjt j
		JNIISLMap lt_ij = JNIISLMap.lexLT(sched_prdg.copy().getDomain().getSpace());
		JNIISLMap le_ij = JNIISLMap.lexLE(sched_prdg.copy().getDomain().getSpace());
		JNIISLMap gt_ij = JNIISLMap.lexGT(sched_prdg.copy().getDomain().getSpace());
		JNIISLMap ge_ij = JNIISLMap.lexGE(sched_prdg.copy().getDomain().getSpace());

		System.out.println("lt_ij="+lt_ij);
		System.out.println("le_ij="+le_ij);
		System.out.println("gt_ij="+gt_ij);
		System.out.println("ge_ij="+ge_ij);

		JNIISLMap conflict = JNIISLMap.applyRange(lastUse.copy(), gt_ij.copy());
		System.out.println("conflict (i'<=lastUse(i))="+conflict );

		
		conflict = JNIISLMap.intersect(conflict.copy(), le_ij.copy());
		System.out.println("conflict (i<i'<=lastUse(i))="+conflict );

		conflict = JNIISLMap.union(conflict.copy(), conflict.copy().reverse());
		JNIISLSet scheduled_dom = dom.copy().apply(schedule); 
		conflict = JNIISLMap.intersectDomain(conflict.copy(), scheduled_dom.copy()); 
		conflict = JNIISLMap.intersectRange(conflict.copy(), scheduled_dom.copy()); 
		JNIISLSet flat_conflicts = conflict.copy().wrap().flatten();
		System.out.println("CS="+flat_conflicts);
		
 
		JNIISLMap islMap = ISLFactory.islMap(_deltamap);
		flat_conflicts = flat_conflicts.copy().apply(islMap.copy());

		System.out.println("DS="+flat_conflicts.copy());

		JNIISLSet proj = flat_conflicts .copy();
		long size = flat_conflicts.getNDim();
		for(int i =0; i< size;i++) {
			proj = flat_conflicts.copy();
			if(i<size-1) {
				proj = proj.copy().projectOut(JNIISLDimType.isl_dim_set, i+1, size-i-1).coalesce();
				System.out.println("projecting out "+(size-i-1)+" dimensions starting after "+(i+1));
			}
			if(i>0) {
				proj = proj.copy().projectOut(JNIISLDimType.isl_dim_set, 0, i).coalesce();
				System.out.println("projecting out "+(i)+" dimensions starting after 0");
			}
			System.out.println("proj = "+proj);
			JNIISLSet min = proj.copy().lexMin();

			
			System.out.println("min = "+min);
			JNIISLSet max = proj.copy().lexMax();
			System.out.println("max= "+max);
		}
		
/*
 *conflict (i'<lastUse(i))=[M] -> { 
 *[c0, c1] -> [c0', c1'] : c0' >= 1 and c0' <= M and c1' >= 0 and c1' <= M and c0' <= c0; [c0, c1] -> [1 + c0, c1'] : c0 >= 0 and c0 <= -1 + M and c1' >= 0 and c1' <= M and c1' <= -1 + c1 }

 */
	}

}
