package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDataflowAnalysis;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLUnionMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLUnionSet;
import junit.framework.TestCase;

public class TestPlutoScheduling extends TestCase {

	public static void computeSchedule(String dom, String prdg) {
		JNIISLUnionSet domains = ISLFactory.islUnionSet(dom);
		JNIISLUnionMap prdgMap = ISLFactory.islUnionMap(prdg);
		JNIISLUnionMap schedule = JNIISLDataflowAnalysis.computePlutoSchedule(domains, prdgMap);
		System.out.println(schedule);
	}
	
	public static void testMatrixProduct() {
		String domains = "[M, N, P] -> { S0[i, j] : i <= -1 + M and i >= 0 and j <= -1 + N and j >= 0; S1[i, j, k] : i <= -1 + M and i >= 0 and j <= -1 + N and j >= 0 and k <= -1 + P and k >= 0 }";
		String prdg = "[M, N, P] -> { S1[i, j, k] -> S1[i, j, 1 + k] : i <= -1 + M and i >= 0 and j <= -1 + N and j >= 0 and k <= -2 + P and k >= 0; S0[i, j] -> S1[i, j, 0] : i <= -1 + M and i >= 0 and j <= -1 + N and j >= 0 and P >= 1 }";
		computeSchedule(domains, prdg);
	}
}
