package fr.irisa.cairn.jnimap.isl.jni.tests.impl;

import junit.framework.TestCase;
import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDim;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDimType;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLTransitiveClosureResult;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLUnionMap;

public class TestUnionMap extends TestCase{
	
	final static String ex0=
		"[N]-> {"+
			"S1[i] -> [s0,s1,s2] : i-N< 0 and i>= 0 and s0=i and  s1=0 and  s2=0;"+
			"S2[i,j] -> [s0,s1,s2] : i-N< 0 and i>= 0 and i-2> 0 and j-N< 0 and j-i>= 0 and s0=i and  s1=j and  s2=1;"+
			"S3[i,j] -> [s0,s1,s2] : i-N< 0 and i>= 0 and i-2> 0 and j-N< 0 and j-i>= 0 and s0=i and  s1=i+j and  s2=1"+
		"}";

	public void testUnionMapfromString() {
		JNIISLUnionMap unionMap = ISLFactory.islUnionMap(ex0);
		//unionMap.transitiveClosure(JNIPtrInt)
		System.out.println(unionMap);
	}
	
	
	final static String ex1="{ A[i] -> A[i+1] : 0 <= i <= 3; B[] -> A[2] }";

	
	public void testUnionMapTransitiveClosure() {
		JNIISLUnionMap unionMap = ISLFactory.islUnionMap(ex1);
		System.out.println("input="+unionMap);
		JNIISLTransitiveClosureResult res  = unionMap.copy().transitiveClosure();
		System.out.println("exact="+res.getExact());
		System.out.println("res="+res.getUmap());
		
	}

	final static String ex2=
		"[N]-> {"+
			"S[i,j] -> S[i+1,j+1]   : i-N< 0 and i>= 0 and j-N< 0 and j>= 0 "+
		"}";


	public void testMapTransitiveClosure() {
		JNIISLMap map = ISLFactory.islMap(ex2);
		System.out.println("input="+map);
		JNIISLTransitiveClosureResult res  = map.copy().transitiveClosure();
		System.out.println("exact="+res.getExact());
		System.out.println("res="+res.getMap());
	}

	public void testWrites() {
		String setTxt = "[N, M, P] -> { S3[] -> a[]; S0[i, j] -> s[]; S1[i, j, k] -> s[]; S2[i, j] -> res[i, j] }";
		JNIISLUnionMap map = ISLFactory.islUnionMap(setTxt);
		String mapstr = map.toString();
		System.out.println(mapstr);
		System.out.println(setTxt);
		assertEquals(mapstr, setTxt);
	}

//	public void testExtractMap() {
//		JNIISLUnionMap unionMap = ISLFactory.islUnionMap(ex0);
//		JNIISLDim dim = 
//		unionMap.extractMap(dim);
//		map.getDimensions().getName(, pos)
//		JNIISLTransitiveClosureResult res  = map.copy().transitiveClosure();
//		System.out.println("exact="+res.getExact());
//		System.out.println("res="+res.getMap());
//	}
}
