/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel;


import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.polymodel.util.IntegerLinearAlgebraPrinter.FORMAT;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Affine Mapping</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.polymodel.AffineMapping#getParams <em>Params</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.AffineMapping#getIndices <em>Indices</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.AffineMapping#getFunctions <em>Functions</em>}</li>
 * </ul>
 * </p>
 *
 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getAffineMapping()
 * @model
 * @generated
 */
public interface AffineMapping extends EObject {
	/**
	 * Returns the value of the '<em><b>Params</b></em>' reference list.
	 * The list contents are of type {@link fr.irisa.cairn.model.integerLinearAlgebra.IVariable}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Params</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Params</em>' reference list.
	 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getAffineMapping_Params()
	 * @model
	 * @generated
	 */
	EList<IVariable> getParams();

	/**
	 * Returns the value of the '<em><b>Indices</b></em>' reference list.
	 * The list contents are of type {@link fr.irisa.cairn.model.integerLinearAlgebra.IVariable}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Indices</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Indices</em>' reference list.
	 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getAffineMapping_Indices()
	 * @model
	 * @generated
	 */
	EList<IVariable> getIndices();

	/**
	 * Returns the value of the '<em><b>Functions</b></em>' containment reference list.
	 * The list contents are of type {@link fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Functions</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Functions</em>' containment reference list.
	 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getAffineMapping_Functions()
	 * @model containment="true"
	 * @generated
	 */
	EList<IntLinearExpression> getFunctions();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	AffineMapping compose(AffineMapping f2);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" funcRequired="true"
	 * @generated
	 */
	boolean equivalence(AffineMapping func);

	AffineMapping inverse() throws PolymodelException;

	AffineMapping inverse(EList<String> newNames) throws PolymodelException;

	AffineMapping inverseInContext(PolyhedralDomain context) throws PolymodelException;
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model exceptions="fr.irisa.cairn.model.polymodel.EPolymodelException" namesMany="true"
	 * @generated
	 */
	AffineMapping inverseInContext(PolyhedralDomain context, EList<String> names) throws PolymodelException;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	Matrix toMatrix();
	
	/**
	 * <!-- begin-user-doc -->
	 * Used in inverse in context. AffineMapping needs to be created by the factory of underlying library specific polymodel.
	 * When indices are not given, generates indices to match the dimensions.
	 * <!-- end-user-doc -->
	 * @model required="true" matrixRequired="true" paramsMany="true" indicesMany="true"
	 * @generated
	 */
	AffineMapping toAffineMapping(Matrix matrix, EList<IVariable> params, EList<IVariable> indices);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	int getDimRHS();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	int getDimLHS();

	List<String> getFunctions(FORMAT format);

} // AffineMapping
