/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel;


import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.polymodel.util.IntegerLinearAlgebraPrinter.FORMAT;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Polyhedral Domain</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain#getPolyhedra <em>Polyhedra</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain#getParams <em>Params</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain#getExistential <em>Existential</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain#getIndices <em>Indices</em>}</li>
 * </ul>
 * </p>
 *
 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getPolyhedralDomain()
 * @model
 * @generated
 */
public interface PolyhedralDomain extends EObject {
	/**
	 * Returns the value of the '<em><b>Polyhedra</b></em>' containment reference list.
	 * The list contents are of type {@link fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Polyhedra</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Polyhedra</em>' containment reference list.
	 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getPolyhedralDomain_Polyhedra()
	 * @model containment="true"
	 * @generated
	 */
	EList<IntLinearConstraintSystem> getPolyhedra();

	/**
	 * Returns the value of the '<em><b>Params</b></em>' reference list.
	 * The list contents are of type {@link fr.irisa.cairn.model.integerLinearAlgebra.IVariable}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Params</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Params</em>' reference list.
	 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getPolyhedralDomain_Params()
	 * @model
	 * @generated
	 */
	EList<IVariable> getParams();

	/**
	 * Returns the value of the '<em><b>Existential</b></em>' reference list.
	 * The list contents are of type {@link fr.irisa.cairn.model.integerLinearAlgebra.IVariable}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Existential</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Existential</em>' reference list.
	 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getPolyhedralDomain_Existential()
	 * @model
	 * @generated
	 */
	EList<IVariable> getExistential();

	/**
	 * Returns the value of the '<em><b>Indices</b></em>' reference list.
	 * The list contents are of type {@link fr.irisa.cairn.model.integerLinearAlgebra.IVariable}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Indices</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Indices</em>' reference list.
	 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#getPolyhedralDomain_Indices()
	 * @model
	 * @generated
	 */
	EList<IVariable> getIndices();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	PolyhedralDomain difference(PolyhedralDomain d);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	PolyhedralDomain intersection(PolyhedralDomain d);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	PolyhedralDomain union(PolyhedralDomain d);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true"
	 * @generated
	 */
	boolean equivalence(PolyhedralDomain d);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	boolean isUniverse();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	boolean isEmpty();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	void simplify();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	PolyhedralDomain image(AffineMapping T);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	PolyhedralDomain preimage(AffineMapping T);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true"
	 * @generated
	 */
	PolyhedralDomain boundingBox();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	EList<Matrix> toMatrices();
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	void addConstraint(IntLinearConstraint constraint);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	int getNIndices();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	int getNParams();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true"
	 * @generated
	 */
	PolyhedralDomain complement();

	List<List<String>> getConstraintList(FORMAT format);

	EList<String> getIndexNames();
	EList<String> getParamNames();


} // PolyhedralDomain
