/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel;

import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see fr.irisa.cairn.model.polymodel.PolymodelFactory
 * @model kind="package"
 * @generated
 */
public interface PolymodelPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "polymodel";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "polymodel";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "polymodel";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	PolymodelPackage eINSTANCE = fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl.init();

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl <em>Polyhedral Domain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getPolyhedralDomain()
	 * @generated
	 */
	int POLYHEDRAL_DOMAIN = 0;

	/**
	 * The feature id for the '<em><b>Polyhedra</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN__POLYHEDRA = 0;

	/**
	 * The feature id for the '<em><b>Params</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN__PARAMS = 1;

	/**
	 * The feature id for the '<em><b>Existential</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN__EXISTENTIAL = 2;

	/**
	 * The feature id for the '<em><b>Indices</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN__INDICES = 3;

	/**
	 * The number of structural features of the '<em>Polyhedral Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainWithScopeImpl <em>Polyhedral Domain With Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainWithScopeImpl
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getPolyhedralDomainWithScope()
	 * @generated
	 */
	int POLYHEDRAL_DOMAIN_WITH_SCOPE = 1;

	/**
	 * The feature id for the '<em><b>Polyhedra</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN_WITH_SCOPE__POLYHEDRA = POLYHEDRAL_DOMAIN__POLYHEDRA;

	/**
	 * The feature id for the '<em><b>Params</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN_WITH_SCOPE__PARAMS = POLYHEDRAL_DOMAIN__PARAMS;

	/**
	 * The feature id for the '<em><b>Existential</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN_WITH_SCOPE__EXISTENTIAL = POLYHEDRAL_DOMAIN__EXISTENTIAL;

	/**
	 * The feature id for the '<em><b>Indices</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN_WITH_SCOPE__INDICES = POLYHEDRAL_DOMAIN__INDICES;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN_WITH_SCOPE__SCOPE = POLYHEDRAL_DOMAIN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Polyhedral Domain With Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYHEDRAL_DOMAIN_WITH_SCOPE_FEATURE_COUNT = POLYHEDRAL_DOMAIN_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.impl.MatrixImpl <em>Matrix</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.impl.MatrixImpl
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getMatrix()
	 * @generated
	 */
	int MATRIX = 2;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MATRIX__ROWS = 0;

	/**
	 * The number of structural features of the '<em>Matrix</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MATRIX_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.impl.MatrixRowImpl <em>Matrix Row</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.impl.MatrixRowImpl
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getMatrixRow()
	 * @generated
	 */
	int MATRIX_ROW = 3;

	/**
	 * The feature id for the '<em><b>Values</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MATRIX_ROW__VALUES = 0;

	/**
	 * The number of structural features of the '<em>Matrix Row</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MATRIX_ROW_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.impl.AffineMappingImpl <em>Affine Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.impl.AffineMappingImpl
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getAffineMapping()
	 * @generated
	 */
	int AFFINE_MAPPING = 4;

	/**
	 * The feature id for the '<em><b>Params</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING__PARAMS = 0;

	/**
	 * The feature id for the '<em><b>Indices</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING__INDICES = 1;

	/**
	 * The feature id for the '<em><b>Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING__FUNCTIONS = 2;

	/**
	 * The number of structural features of the '<em>Affine Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.impl.AffineMappingWithScopeImpl <em>Affine Mapping With Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.impl.AffineMappingWithScopeImpl
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getAffineMappingWithScope()
	 * @generated
	 */
	int AFFINE_MAPPING_WITH_SCOPE = 5;

	/**
	 * The feature id for the '<em><b>Params</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING_WITH_SCOPE__PARAMS = AFFINE_MAPPING__PARAMS;

	/**
	 * The feature id for the '<em><b>Indices</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING_WITH_SCOPE__INDICES = AFFINE_MAPPING__INDICES;

	/**
	 * The feature id for the '<em><b>Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING_WITH_SCOPE__FUNCTIONS = AFFINE_MAPPING__FUNCTIONS;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING_WITH_SCOPE__SCOPE = AFFINE_MAPPING_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Affine Mapping With Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_MAPPING_WITH_SCOPE_FEATURE_COUNT = AFFINE_MAPPING_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.impl.VertexImpl <em>Vertex</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.impl.VertexImpl
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getVertex()
	 * @generated
	 */
	int VERTEX = 6;

	/**
	 * The feature id for the '<em><b>Values</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERTEX__VALUES = MATRIX_ROW__VALUES;

	/**
	 * The feature id for the '<em><b>Denominator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERTEX__DENOMINATOR = MATRIX_ROW_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Vertex</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERTEX_FEATURE_COUNT = MATRIX_ROW_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.impl.IndexDimensionImpl <em>Index Dimension</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.impl.IndexDimensionImpl
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getIndexDimension()
	 * @generated
	 */
	int INDEX_DIMENSION = 7;

	/**
	 * The feature id for the '<em><b>Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX_DIMENSION__DIMENSION = IntegerLinearAlgebraPackage.IVARIABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX_DIMENSION__NAME = IntegerLinearAlgebraPackage.IVARIABLE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Index Dimension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX_DIMENSION_FEATURE_COUNT = IntegerLinearAlgebraPackage.IVARIABLE_FEATURE_COUNT + 2;


	/**
	 * The meta object id for the '<em>EPolymodel Exception</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.PolymodelException
	 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getEPolymodelException()
	 * @generated
	 */
	int EPOLYMODEL_EXCEPTION = 8;


	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain <em>Polyhedral Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Polyhedral Domain</em>'.
	 * @see fr.irisa.cairn.model.polymodel.PolyhedralDomain
	 * @generated
	 */
	EClass getPolyhedralDomain();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain#getPolyhedra <em>Polyhedra</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Polyhedra</em>'.
	 * @see fr.irisa.cairn.model.polymodel.PolyhedralDomain#getPolyhedra()
	 * @see #getPolyhedralDomain()
	 * @generated
	 */
	EReference getPolyhedralDomain_Polyhedra();

	/**
	 * Returns the meta object for the reference list '{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain#getParams <em>Params</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Params</em>'.
	 * @see fr.irisa.cairn.model.polymodel.PolyhedralDomain#getParams()
	 * @see #getPolyhedralDomain()
	 * @generated
	 */
	EReference getPolyhedralDomain_Params();

	/**
	 * Returns the meta object for the reference list '{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain#getExistential <em>Existential</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Existential</em>'.
	 * @see fr.irisa.cairn.model.polymodel.PolyhedralDomain#getExistential()
	 * @see #getPolyhedralDomain()
	 * @generated
	 */
	EReference getPolyhedralDomain_Existential();

	/**
	 * Returns the meta object for the reference list '{@link fr.irisa.cairn.model.polymodel.PolyhedralDomain#getIndices <em>Indices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Indices</em>'.
	 * @see fr.irisa.cairn.model.polymodel.PolyhedralDomain#getIndices()
	 * @see #getPolyhedralDomain()
	 * @generated
	 */
	EReference getPolyhedralDomain_Indices();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.PolyhedralDomainWithScope <em>Polyhedral Domain With Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Polyhedral Domain With Scope</em>'.
	 * @see fr.irisa.cairn.model.polymodel.PolyhedralDomainWithScope
	 * @generated
	 */
	EClass getPolyhedralDomainWithScope();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.Matrix <em>Matrix</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Matrix</em>'.
	 * @see fr.irisa.cairn.model.polymodel.Matrix
	 * @generated
	 */
	EClass getMatrix();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.polymodel.Matrix#getRows <em>Rows</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Rows</em>'.
	 * @see fr.irisa.cairn.model.polymodel.Matrix#getRows()
	 * @see #getMatrix()
	 * @generated
	 */
	EReference getMatrix_Rows();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.MatrixRow <em>Matrix Row</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Matrix Row</em>'.
	 * @see fr.irisa.cairn.model.polymodel.MatrixRow
	 * @generated
	 */
	EClass getMatrixRow();

	/**
	 * Returns the meta object for the attribute list '{@link fr.irisa.cairn.model.polymodel.MatrixRow#getValues <em>Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Values</em>'.
	 * @see fr.irisa.cairn.model.polymodel.MatrixRow#getValues()
	 * @see #getMatrixRow()
	 * @generated
	 */
	EAttribute getMatrixRow_Values();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.AffineMapping <em>Affine Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Affine Mapping</em>'.
	 * @see fr.irisa.cairn.model.polymodel.AffineMapping
	 * @generated
	 */
	EClass getAffineMapping();

	/**
	 * Returns the meta object for the reference list '{@link fr.irisa.cairn.model.polymodel.AffineMapping#getParams <em>Params</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Params</em>'.
	 * @see fr.irisa.cairn.model.polymodel.AffineMapping#getParams()
	 * @see #getAffineMapping()
	 * @generated
	 */
	EReference getAffineMapping_Params();

	/**
	 * Returns the meta object for the reference list '{@link fr.irisa.cairn.model.polymodel.AffineMapping#getIndices <em>Indices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Indices</em>'.
	 * @see fr.irisa.cairn.model.polymodel.AffineMapping#getIndices()
	 * @see #getAffineMapping()
	 * @generated
	 */
	EReference getAffineMapping_Indices();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.polymodel.AffineMapping#getFunctions <em>Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Functions</em>'.
	 * @see fr.irisa.cairn.model.polymodel.AffineMapping#getFunctions()
	 * @see #getAffineMapping()
	 * @generated
	 */
	EReference getAffineMapping_Functions();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.AffineMappingWithScope <em>Affine Mapping With Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Affine Mapping With Scope</em>'.
	 * @see fr.irisa.cairn.model.polymodel.AffineMappingWithScope
	 * @generated
	 */
	EClass getAffineMappingWithScope();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.Vertex <em>Vertex</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Vertex</em>'.
	 * @see fr.irisa.cairn.model.polymodel.Vertex
	 * @generated
	 */
	EClass getVertex();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.polymodel.Vertex#getDenominator <em>Denominator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Denominator</em>'.
	 * @see fr.irisa.cairn.model.polymodel.Vertex#getDenominator()
	 * @see #getVertex()
	 * @generated
	 */
	EAttribute getVertex_Denominator();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.IndexDimension <em>Index Dimension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Index Dimension</em>'.
	 * @see fr.irisa.cairn.model.polymodel.IndexDimension
	 * @generated
	 */
	EClass getIndexDimension();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.polymodel.IndexDimension#getDimension <em>Dimension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dimension</em>'.
	 * @see fr.irisa.cairn.model.polymodel.IndexDimension#getDimension()
	 * @see #getIndexDimension()
	 * @generated
	 */
	EAttribute getIndexDimension_Dimension();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.polymodel.IndexDimension#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.irisa.cairn.model.polymodel.IndexDimension#getName()
	 * @see #getIndexDimension()
	 * @generated
	 */
	EAttribute getIndexDimension_Name();

	/**
	 * Returns the meta object for data type '{@link fr.irisa.cairn.model.polymodel.PolymodelException <em>EPolymodel Exception</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>EPolymodel Exception</em>'.
	 * @see fr.irisa.cairn.model.polymodel.PolymodelException
	 * @model instanceClass="fr.irisa.cairn.model.polymodel.PolymodelException" serializeable="false"
	 * @generated
	 */
	EDataType getEPolymodelException();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	PolymodelFactory getPolymodelFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl <em>Polyhedral Domain</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getPolyhedralDomain()
		 * @generated
		 */
		EClass POLYHEDRAL_DOMAIN = eINSTANCE.getPolyhedralDomain();

		/**
		 * The meta object literal for the '<em><b>Polyhedra</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POLYHEDRAL_DOMAIN__POLYHEDRA = eINSTANCE.getPolyhedralDomain_Polyhedra();

		/**
		 * The meta object literal for the '<em><b>Params</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POLYHEDRAL_DOMAIN__PARAMS = eINSTANCE.getPolyhedralDomain_Params();

		/**
		 * The meta object literal for the '<em><b>Existential</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POLYHEDRAL_DOMAIN__EXISTENTIAL = eINSTANCE.getPolyhedralDomain_Existential();

		/**
		 * The meta object literal for the '<em><b>Indices</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POLYHEDRAL_DOMAIN__INDICES = eINSTANCE.getPolyhedralDomain_Indices();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainWithScopeImpl <em>Polyhedral Domain With Scope</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainWithScopeImpl
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getPolyhedralDomainWithScope()
		 * @generated
		 */
		EClass POLYHEDRAL_DOMAIN_WITH_SCOPE = eINSTANCE.getPolyhedralDomainWithScope();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.impl.MatrixImpl <em>Matrix</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.impl.MatrixImpl
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getMatrix()
		 * @generated
		 */
		EClass MATRIX = eINSTANCE.getMatrix();

		/**
		 * The meta object literal for the '<em><b>Rows</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MATRIX__ROWS = eINSTANCE.getMatrix_Rows();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.impl.MatrixRowImpl <em>Matrix Row</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.impl.MatrixRowImpl
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getMatrixRow()
		 * @generated
		 */
		EClass MATRIX_ROW = eINSTANCE.getMatrixRow();

		/**
		 * The meta object literal for the '<em><b>Values</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MATRIX_ROW__VALUES = eINSTANCE.getMatrixRow_Values();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.impl.AffineMappingImpl <em>Affine Mapping</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.impl.AffineMappingImpl
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getAffineMapping()
		 * @generated
		 */
		EClass AFFINE_MAPPING = eINSTANCE.getAffineMapping();

		/**
		 * The meta object literal for the '<em><b>Params</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AFFINE_MAPPING__PARAMS = eINSTANCE.getAffineMapping_Params();

		/**
		 * The meta object literal for the '<em><b>Indices</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AFFINE_MAPPING__INDICES = eINSTANCE.getAffineMapping_Indices();

		/**
		 * The meta object literal for the '<em><b>Functions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AFFINE_MAPPING__FUNCTIONS = eINSTANCE.getAffineMapping_Functions();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.impl.AffineMappingWithScopeImpl <em>Affine Mapping With Scope</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.impl.AffineMappingWithScopeImpl
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getAffineMappingWithScope()
		 * @generated
		 */
		EClass AFFINE_MAPPING_WITH_SCOPE = eINSTANCE.getAffineMappingWithScope();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.impl.VertexImpl <em>Vertex</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.impl.VertexImpl
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getVertex()
		 * @generated
		 */
		EClass VERTEX = eINSTANCE.getVertex();

		/**
		 * The meta object literal for the '<em><b>Denominator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VERTEX__DENOMINATOR = eINSTANCE.getVertex_Denominator();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.impl.IndexDimensionImpl <em>Index Dimension</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.impl.IndexDimensionImpl
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getIndexDimension()
		 * @generated
		 */
		EClass INDEX_DIMENSION = eINSTANCE.getIndexDimension();

		/**
		 * The meta object literal for the '<em><b>Dimension</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INDEX_DIMENSION__DIMENSION = eINSTANCE.getIndexDimension_Dimension();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INDEX_DIMENSION__NAME = eINSTANCE.getIndexDimension_Name();

		/**
		 * The meta object literal for the '<em>EPolymodel Exception</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.PolymodelException
		 * @see fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl#getEPolymodelException()
		 * @generated
		 */
		EDataType EPOLYMODEL_EXCEPTION = eINSTANCE.getEPolymodelException();

	}

} //PolymodelPackage
