/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.Matrix;
import fr.irisa.cairn.model.polymodel.MatrixRow;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.PolymodelException;
import fr.irisa.cairn.model.polymodel.PolymodelFactory;
import fr.irisa.cairn.model.polymodel.PolymodelPackage;
import fr.irisa.cairn.model.polymodel.util.IntegerLinearAlgebraPrinter;
import fr.irisa.cairn.model.polymodel.util.IntegerLinearAlgebraPrinter.FORMAT;
import fr.irisa.cairn.model.polymodel.util.PolymodelMatrixOperation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Affine Mapping</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.AffineMappingImpl#getParams <em>Params</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.AffineMappingImpl#getIndices <em>Indices</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.AffineMappingImpl#getFunctions <em>Functions</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AffineMappingImpl extends EObjectImpl implements AffineMapping {
	/**
	 * The cached value of the '{@link #getParams() <em>Params</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParams()
	 * @generated
	 * @ordered
	 */
	protected EList<IVariable> params;
	/**
	 * The cached value of the '{@link #getIndices() <em>Indices</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIndices()
	 * @generated
	 * @ordered
	 */
	protected EList<IVariable> indices;
	/**
	 * The cached value of the '{@link #getFunctions() <em>Functions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFunctions()
	 * @generated
	 * @ordered
	 */
	protected EList<IntLinearExpression> functions;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AffineMappingImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return PolymodelPackage.Literals.AFFINE_MAPPING;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IVariable> getParams() {
		if (params == null) {
			params = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.AFFINE_MAPPING__PARAMS);
		}
		return params;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IVariable> getIndices() {
		if (indices == null) {
			indices = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.AFFINE_MAPPING__INDICES);
		}
		return indices;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IntLinearExpression> getFunctions() {
		if (functions == null) {
			functions = new EObjectContainmentEList<IntLinearExpression>(IntLinearExpression.class, this, PolymodelPackage.AFFINE_MAPPING__FUNCTIONS);
		}
		return functions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AffineMapping compose(AffineMapping f2) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean equivalence(AffineMapping func) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	public AffineMapping inverse() throws PolymodelException {
		return inverseInContext(null);
	}

	public AffineMapping inverse(EList<String> newNames) throws PolymodelException {
		return inverseInContext(null, newNames);
	}

	public AffineMapping inverseInContext(PolyhedralDomain context) throws PolymodelException {
		return inverseInContext(context, null);
	}

	/**
	 * <!-- begin-user-doc -->
	 * Computes inverse function in the context of given domain.
	 * Uses the variables given as index names on the value of the.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public AffineMapping inverseInContext(PolyhedralDomain context, EList<String> names) throws PolymodelException {
		//Use the MDE factory for now TODO
		PolymodelFactory fact = PolymodelFactory.eINSTANCE;
		PolymodelMatrixOperation matOP = PolymodelMatrixOperation.instance(fact);
		
		//Matrix form of the mapping
		Matrix Tmat = fact.createMatrix();

		Matrix thisMat = this.toMatrix();
		
		//Add implicit identity of parameters
		for (int i = 0; i < getParams().size(); i++) {
			MatrixRow row = fact.createMatrixRow();
			//expand the row to be the same size
			row.set(getParams().size()+getIndices().size(), 0);
			//set 1 to the corresponding index
			row.set(i, 1);
			
			Tmat.getRows().add(row);
		}
		Tmat.getRows().addAll(thisMat.getRows());
		
		//When context is not given simply take the inverse with no context
		if (context == null) {
			Matrix inverse = matOP.getInverseInContext(Tmat, fact.createMatrix());
			return toAffineMapping(inverse, getParams(), null);
		} else {
			//Find inverseInContext for all polyhedron consisting the union of context
			AffineMapping inverse = null;
			for (Matrix mat : context.toMatrices()) {
				//Extract equalities
				Matrix eqs = fact.createMatrix();
				for (MatrixRow row : mat.getRows()) {
					//If the constraint is an equality
					if (row.get(0) == 0) {
						MatrixRow eq = fact.createMatrixRow();
						for (int i = 1; i < row.getSize(); i++) {
							eq.getValues().add(row.get(i));
						}
						eqs.getRows().add(eq);
					}
				}
				Matrix inv = matOP.getInverseInContext(Tmat, eqs);
				if (inverse == null) {
					inverse = toAffineMapping(inv, params, null);
				} else {
					AffineMapping inv2 = toAffineMapping(inv, params, null);
					if (!inv2.equivalence(inverse)) {
						throw new RuntimeException("Two inverse found in each polyhedron for unions of polyhedra is not equivalent.");
					}
				}
			}
			return inverse;
		}
		
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * Returns the Matrix form of the mapping.
	 * Each row is a dimension of the function, 
	 * and each column is the linear coefficient of corresponding parameter/index
	 * except for last column, which is the constant.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Matrix toMatrix() {
		//TODO uses EMF factory for now
		Matrix mat = PolymodelFactory.eINSTANCE.createMatrix();
		
		//Iterate over each linear expression
		for (IntLinearExpression ile : getFunctions()) {
			MatrixRow row = PolymodelFactory.eINSTANCE.createMatrixRow();
			
			//Iterate through all expressions
			for (IntExpression ie : ile.getTerms()) {
				if (ie instanceof IntTermExpression) {
					IntTermExpression term = (IntTermExpression)ie;
					//constant
					if (term.getVar() == null) {
						//Last column
						row.set(getParams().size() + getIndices().size(), term.getValue());
					} else {
						//Find out the right column for the term
						int index = 0;
						//Look for the term in the params list
						if (getParams().indexOf(term.getVar()) >= 0) {
							index += getParams().indexOf(term.getVar());
						} else {
							//If its not in param list, offset by size of the param and look in the indices list
							index += getParams().size();
							if (getIndices().indexOf(term.getVar())  >= 0) {
								index += getIndices().indexOf(term.getVar());
							} else {
								throw new RuntimeException("Variable " + term.getVar() + " not found in the mapping " + this);
							}
						}
						row.set(index, term.getValue());
					}
				}
			}
			
			//Make sure that the constant term was encountered
			if (row.getSize() <= getParams().size() + getIndices().size()) {
				row.set( getParams().size() + getIndices().size(), 0);
			}
			
			mat.getRows().add(row);
		}
		
		return mat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AffineMapping toAffineMapping(Matrix matrix, EList<IVariable> params, EList<IVariable> indices) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getDimRHS() {
		return getFunctions().size();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getDimLHS() {
		return getIndices().size();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case PolymodelPackage.AFFINE_MAPPING__FUNCTIONS:
				return ((InternalEList<?>)getFunctions()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case PolymodelPackage.AFFINE_MAPPING__PARAMS:
				return getParams();
			case PolymodelPackage.AFFINE_MAPPING__INDICES:
				return getIndices();
			case PolymodelPackage.AFFINE_MAPPING__FUNCTIONS:
				return getFunctions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case PolymodelPackage.AFFINE_MAPPING__PARAMS:
				getParams().clear();
				getParams().addAll((Collection<? extends IVariable>)newValue);
				return;
			case PolymodelPackage.AFFINE_MAPPING__INDICES:
				getIndices().clear();
				getIndices().addAll((Collection<? extends IVariable>)newValue);
				return;
			case PolymodelPackage.AFFINE_MAPPING__FUNCTIONS:
				getFunctions().clear();
				getFunctions().addAll((Collection<? extends IntLinearExpression>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case PolymodelPackage.AFFINE_MAPPING__PARAMS:
				getParams().clear();
				return;
			case PolymodelPackage.AFFINE_MAPPING__INDICES:
				getIndices().clear();
				return;
			case PolymodelPackage.AFFINE_MAPPING__FUNCTIONS:
				getFunctions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case PolymodelPackage.AFFINE_MAPPING__PARAMS:
				return params != null && !params.isEmpty();
			case PolymodelPackage.AFFINE_MAPPING__INDICES:
				return indices != null && !indices.isEmpty();
			case PolymodelPackage.AFFINE_MAPPING__FUNCTIONS:
				return functions != null && !functions.isEmpty();
		}
		return super.eIsSet(featureID);
	}
	

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected String toStringList(List<?> list, String separator ) {
		StringBuffer buff = new StringBuffer();
		if(list==null) return "";
		boolean first =true;
		for (Object obj : list) {
			if (first) {
				first =false;
				buff.append(obj.toString());
			} else {
				buff.append(separator+obj.toString());
				
			}
		}
		return buff.toString();
	}
	
	/**
	 * @generated NOT
	 */
	@Override 
	public String toString() {
		String lhsP = toStringList(this.params, ",");
		String lhsI = toStringList(this.indices, ",");
		String lhs = null;
		if (params.size() > 0 && indices.size() > 0) {
			lhs = lhsP + "," + lhsI;
		} else {
			lhs = lhsP+lhsI;
		}
		String rhs = toStringList(functions, ",");
		
		return "(" + lhs + "->" + rhs + ")";
	}

	@Override
	public List<String> getFunctions(FORMAT format) {
		List<String> funcs = new LinkedList<String>();

		for (IntLinearExpression ile : getFunctions()) {
			funcs.add(IntegerLinearAlgebraPrinter.toString(ile, format));
		}
		
		return funcs;
	}

} //AffineMappingImpl
