/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.EcoreUtil.Copier;
import org.eclipse.emf.ecore.util.InternalEList;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;
import fr.irisa.cairn.model.polymodel.Matrix;
import fr.irisa.cairn.model.polymodel.MatrixRow;
import fr.irisa.cairn.model.polymodel.PolymodelFactory;
import fr.irisa.cairn.model.polymodel.PolymodelPackage;
import fr.irisa.cairn.model.polymodel.util.PolymodelMatrixOperation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Matrix</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.MatrixImpl#getRows <em>Rows</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MatrixImpl extends EObjectImpl implements Matrix {
	/**
	 * The cached value of the '{@link #getRows() <em>Rows</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRows()
	 * @generated
	 * @ordered
	 */
	protected EList<MatrixRow> rows;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MatrixImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return PolymodelPackage.Literals.MATRIX;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MatrixRow> getRows() {
		if (rows == null) {
			rows = new EObjectContainmentEList<MatrixRow>(MatrixRow.class, this, PolymodelPackage.MATRIX__ROWS);
		}
		return rows;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Matrix inverse() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Matrix mul(Matrix b) {
		return PolymodelMatrixOperation.instance(PolymodelFactory.eINSTANCE).mul(this, b);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Matrix transpose() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Matrix identity(int size) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Matrix> findHermiteBasis() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isUnimodular() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInHNF() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIntegral() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Matrix> left_hermite() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}


	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public boolean isIdentity() {
		if (isSquare()) {
			for(int i=0;i<getNbCols();++i){
				long l = get(i, i);
				if(l!=1)
					return false;
			}
			return true;
		} 
		return false;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public boolean isSquare() {
		return getNbCols() == getNbRows();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case PolymodelPackage.MATRIX__ROWS:
				return ((InternalEList<?>)getRows()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case PolymodelPackage.MATRIX__ROWS:
				return getRows();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case PolymodelPackage.MATRIX__ROWS:
				getRows().clear();
				getRows().addAll((Collection<? extends MatrixRow>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case PolymodelPackage.MATRIX__ROWS:
				getRows().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case PolymodelPackage.MATRIX__ROWS:
				return rows != null && !rows.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	public IntLinearConstraintSystem toConstraintsSystem(List<? extends IVariable> varnames) {
			IntLinearConstraintSystem system = IntegerExpressionUserFactory.linConstraintSystem();
			for (int j = 0; j < getNbRows(); ++j) {
				IntExpression newExpr = IntegerExpressionUserFactory.linexp();
				
				for (int i = 1; i < getNbCols() - 1; ++i) {
					long value = get(j, i);
					if (value != 0) {
						IntTermExpression term = IntegerExpressionUserFactory.term((int)value,varnames.get(i-1));
						newExpr= IntegerExpressionUserFactory.add(newExpr,term);
					}
				}
				long value = get(j, getNbCols() - 1);
				if (value != 0) {
					IntTermExpression term = IntegerExpressionUserFactory.term((int)value);
					newExpr= IntegerExpressionUserFactory.add(newExpr,term);
				}

				boolean isineq = true;

				if (get(j, 0) == 0) {
					// Equality
					isineq = false;
				} else if (get(j, 0) == -1) {
					newExpr=IntegerExpressionUserFactory.mul(-1, newExpr);
					isineq = true;
				} else if (get(j, 0) == 1) {
					isineq = true;
				}
				IntLinearExpression newExpr2 = IntegerExpressionUserFactory.linexp(newExpr.simplify());
//				IntLinearConstraint newEqu = IntegerExpressionUserFactory.linConstraint(newExpr2, isineq?Operator.LE:Operator.EQ);
				IntLinearConstraint newEqu = IntegerExpressionUserFactory.linConstraint(newExpr2, isineq?Operator.GE:Operator.EQ);
				system.getLinearConstraints().add(newEqu);
			}
			return system;
		}

	public long get(int row, int col) {
		if(row>=getNbRows()) throw new RuntimeException("Row index "+row+" is out of bound fior matrix "+getNbRows()+"x"+getNbCols());
		if(col>=getNbCols()) throw new RuntimeException("Columns index "+col+" is out of bound fior matrix "+getNbRows()+"x"+getNbCols());
		return getRow(row).get(col);
	}

	public int getNbRows() {
		return getRows().size();
	}

	public int getNbCols() {
		if(getRows().size()>0) {
			MatrixRow matrixRow = getRows().get(0);
			return matrixRow.getValues().size();
		} else {
			return 0;
		}
	}

	public Matrix copy() {
		Copier copier  = new EcoreUtil.Copier();
		return (Matrix) copier.copy(this);
	}

	public void set(int j, int i, long val) {
		getRow(j).set(i, val);
	}

	public EList<Long> getRow(int j) {
		return getRows().get(j).getValues();
	}

	public String toString() {
		StringBuffer tmp = new StringBuffer();
		tmp.append("\nMatrix [" + getNbCols() + "x" + getNbRows() + "]\n");
		for (int j = 0; j < getNbRows(); j++) {
			tmp.append(getRows().get(j)+"\n");
		}
		tmp.append("\n");
		return tmp.toString();
	}


} //MatrixImpl
