/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EDataTypeEList;

import fr.irisa.cairn.model.polymodel.MatrixRow;
import fr.irisa.cairn.model.polymodel.PolymodelPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Matrix Row</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.MatrixRowImpl#getValues <em>Values</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MatrixRowImpl extends EObjectImpl implements MatrixRow {
	/**
	 * The cached value of the '{@link #getValues() <em>Values</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValues()
	 * @generated
	 * @ordered
	 */
	protected EList<Long> values;
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MatrixRowImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return PolymodelPackage.Literals.MATRIX_ROW;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Long> getValues() {
		if (values == null) {
			// changed EDataTypeUniqueEList by simple EDataTypeEList
			values = new EDataTypeEList<Long>(Long.class, this, PolymodelPackage.MATRIX_ROW__VALUES);
		}
		return values;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getSize() {
		return getValues().size();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String toConstraint(EList<String> names) {
		if (names == null) {
			names = new BasicEList<String>();
			for (int i = 0; i < getSize() - 2; i++) {
				names.add("i"+i);
			}
		}
		//constant
		StringBuffer sb = new StringBuffer(getValues().get(getSize()-1)+"");
		
		//First column is for eq/ineq and last is for constant
		for (int i = 1; i < getSize()-1; i++) {
			long val = getValues().get(i);
			//sign
			if (val > 0) {
				sb.append("+");
			} else if (val < 0) {
				sb.append("-");
			}
			//when the value is larget than 1 (or smaller than -1), numbers show up
			if (Math.abs(val) > 1) {
				sb.append(""+Math.abs(val));
			}
			//then the name shows up unless its 0
			if (val != 0) {
				sb.append(names.get(i-1));
			}

		}
		
		// eq/ineq
		if (getValues().get(0) == 0) {
			sb.append(" == 0");
		} else {
			sb.append(">= 0");
		}
		
		return sb.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case PolymodelPackage.MATRIX_ROW__VALUES:
				return getValues();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case PolymodelPackage.MATRIX_ROW__VALUES:
				getValues().clear();
				getValues().addAll((Collection<? extends Long>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case PolymodelPackage.MATRIX_ROW__VALUES:
				getValues().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case PolymodelPackage.MATRIX_ROW__VALUES:
				return values != null && !values.isEmpty();
		}
		return super.eIsSet(featureID);
	}


	public long get(int i) {
		return getValues().get(i);
	}

	public void set(int j, long l) {
		while (getValues().size() <= j) {
			getValues().add((long) 0);
		}
		getValues().set(j,l);
	}

	public MatrixRow copy() {
		MatrixRow res = new MatrixRowImpl();
		res.getValues().addAll(getValues());
		return res;
	}
	
	public String toString() {
		StringBuffer tmp = new StringBuffer();
		tmp.append("[ " );
		for (int j = 0; j < getValues().size(); j++) {
			tmp.append(getValues().get(j)+" ");
		}
		tmp.append("]");
		return tmp.toString();
	}


} //MatrixRowImpl
