/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.IndexDimension;
import fr.irisa.cairn.model.polymodel.Matrix;
import fr.irisa.cairn.model.polymodel.MatrixRow;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.PolymodelFactory;
import fr.irisa.cairn.model.polymodel.PolymodelPackage;
import fr.irisa.cairn.model.polymodel.util.IntegerLinearAlgebraPrinter;
import fr.irisa.cairn.model.polymodel.util.IntegerLinearAlgebraPrinter.FORMAT;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Polyhedral Domain</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl#getPolyhedra <em>Polyhedra</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl#getParams <em>Params</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl#getExistential <em>Existential</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl#getIndices <em>Indices</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PolyhedralDomainImpl extends EObjectImpl implements PolyhedralDomain {
	/**
	 * The cached value of the '{@link #getPolyhedra() <em>Polyhedra</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPolyhedra()
	 * @generated
	 * @ordered
	 */
	protected EList<IntLinearConstraintSystem> polyhedra;

	/**
	 * The cached value of the '{@link #getParams() <em>Params</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParams()
	 * @generated
	 * @ordered
	 */
	protected EList<IVariable> params;

	/**
	 * The cached value of the '{@link #getExistential() <em>Existential</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExistential()
	 * @generated
	 * @ordered
	 */
	protected EList<IVariable> existential;

	protected boolean dirty =true;
	

	/**
	 * The cached value of the '{@link #getIndices() <em>Indices</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIndices()
	 * @generated
	 * @ordered
	 */
	protected EList<IVariable> indices;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PolyhedralDomainImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return PolymodelPackage.Literals.POLYHEDRAL_DOMAIN;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IntLinearConstraintSystem> getPolyhedra() {
		if (polyhedra == null) {
			polyhedra = new EObjectContainmentEList<IntLinearConstraintSystem>(IntLinearConstraintSystem.class, this, PolymodelPackage.POLYHEDRAL_DOMAIN__POLYHEDRA);
		}
		return polyhedra;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IVariable> getParams() {
		if (params == null) {
			params = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.POLYHEDRAL_DOMAIN__PARAMS);
		}
		return params;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IVariable> getExistential() {
		if (existential == null) {
			existential = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.POLYHEDRAL_DOMAIN__EXISTENTIAL);
		}
		return existential;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IVariable> getIndices() {
		if (indices == null) {
			indices = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.POLYHEDRAL_DOMAIN__INDICES);
		}
		return indices;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain difference(PolyhedralDomain d) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain intersection(PolyhedralDomain d) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain union(PolyhedralDomain d) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean equivalence(PolyhedralDomain d) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isUniverse() {
		for (IntLinearConstraintSystem ilcs : getPolyhedra()) {
			if (ilcs.getLinearConstraints().size() > 0) return false;
		}
		
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEmpty() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void simplify() {
		List<IntLinearConstraintSystem> rmList = new LinkedList<IntLinearConstraintSystem>();
		for (IntLinearConstraintSystem ilcs : getPolyhedra()) {
			if (ilcs.getConstraints().size() == 0 && ilcs.getLinearConstraints().size() == 0) {
				rmList.add(ilcs);
			}
		}
		getPolyhedra().removeAll(rmList);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain image(AffineMapping T) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain preimage(AffineMapping T) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain boundingBox() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * Returns matrices (one per polyhedra) that represents the 
	 * constraints of this domain.
	 * The first column is either 0 or 1 denoting if a row is 
	 * equality or inequality constraints. (0 is equality)
	 * The last column is constant, and all other columns are 
	 * coefficients of parameters and indices.
	 * 
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Matrix> toMatrices() {
		
		EList<Matrix> matrices = new BasicEList<Matrix>();
		
		//For each polyhedron
		for (IntLinearConstraintSystem ilcs : getPolyhedra()) {
			Matrix mat = PolymodelFactory.eINSTANCE.createMatrix();
			//Iterate over each constraint (=row)
			for (IntLinearConstraint ilc : ilcs.getLinearConstraints()) {
				MatrixRow row = PolymodelFactory.eINSTANCE.createMatrixRow();
				
				//The first column is 0 for equality and 1 for inequality 
				if (ilc.getComparisonOperator() == Operator.EQ) {
					row.set(0, 0);
				} else if (ilc.getComparisonOperator() == Operator.GE){
					row.set(0, 1);
				} else {
					throw new RuntimeException("toMatrices : Expecting == or >=");
				}
				
				//Iterate through all expressions
				for (IntExpression ile : ilc.getLinexpr().getTerms()) {
					if (ile instanceof IntTermExpression) {
						IntTermExpression term = (IntTermExpression)ile;
						//constant
						if (term.getVar() == null) {
							//Last column
							row.set(getParams().size() + getIndices().size() + 1, term.getValue());
						} else {
							//Find out the right column for the term
							int index = 0;
							//Look for the term in the params list
							if (ECollections.indexOf(getParams(), term.getVar(), 0) >= 0) {
								index += ECollections.indexOf(getParams(), term.getVar(), 0);
							} else {
								//If its not in param list, offset by size of the param and look in the indices list
								index += getParams().size();
								if (ECollections.indexOf(getIndices(), term.getVar(), 0) >= 0) {
									index += ECollections.indexOf(getIndices(), term.getVar(), 0);
								} else {
									throw new RuntimeException("Variable " + term.getVar() + " not found in the polyhedron " + this);
								}
							}
							row.set(index+1, term.getValue());
						}
					}
				}
				
				//Make sure that the constant term was encountered
				if (row.getSize() <= getParams().size() + getIndices().size() + 1) {
					row.set(getParams().size() + getIndices().size()+1, 0);
				}
				
				mat.getRows().add(row);
			}
			matrices.add(mat);
		}
		
		return matrices;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void addConstraint(IntLinearConstraint constraint) {
		for (IntLinearConstraintSystem ilcs : getPolyhedra()) {
			ilcs.getLinearConstraints().add(constraint.copy());
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getNIndices() {
		return getIndices().size();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getNParams() {
		return getParams().size();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain complement() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	public EList<IVariable> getAllParameters() {
		if (this.outerDomain == null) {
			EList<IVariable> ps = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.POLYHEDRAL_DOMAIN__INDICES);
			ps.addAll(this.getParams());
			return ps;
		}
		if (this.outerDomain == null) return getParams();
		EList<IVariable> all = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.POLYHEDRAL_DOMAIN__PARAMS);
		all.addAll(this.outerDomain.getAllParameters());
		all.addAll(this.getParams());
		return all;
	}
	 */

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	public EList<IVariable> getAllIndices() {
		if (this.outerDomain == null) {
			EList<IVariable> is = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.POLYHEDRAL_DOMAIN__INDICES);
			is.addAll(this.getIndices());
			return is;
		}
		EList<IVariable> all = new EObjectResolvingEList<IVariable>(IVariable.class, this, PolymodelPackage.POLYHEDRAL_DOMAIN__INDICES);
		all.addAll(this.outerDomain.getAllIndices());
		all.addAll(this.getIndices());
		return all;
	}
	 */

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case PolymodelPackage.POLYHEDRAL_DOMAIN__POLYHEDRA:
				return ((InternalEList<?>)getPolyhedra()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case PolymodelPackage.POLYHEDRAL_DOMAIN__POLYHEDRA:
				return getPolyhedra();
			case PolymodelPackage.POLYHEDRAL_DOMAIN__PARAMS:
				return getParams();
			case PolymodelPackage.POLYHEDRAL_DOMAIN__EXISTENTIAL:
				return getExistential();
			case PolymodelPackage.POLYHEDRAL_DOMAIN__INDICES:
				return getIndices();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case PolymodelPackage.POLYHEDRAL_DOMAIN__POLYHEDRA:
				getPolyhedra().clear();
				getPolyhedra().addAll((Collection<? extends IntLinearConstraintSystem>)newValue);
				return;
			case PolymodelPackage.POLYHEDRAL_DOMAIN__PARAMS:
				getParams().clear();
				getParams().addAll((Collection<? extends IVariable>)newValue);
				return;
			case PolymodelPackage.POLYHEDRAL_DOMAIN__EXISTENTIAL:
				getExistential().clear();
				getExistential().addAll((Collection<? extends IVariable>)newValue);
				return;
			case PolymodelPackage.POLYHEDRAL_DOMAIN__INDICES:
				getIndices().clear();
				getIndices().addAll((Collection<? extends IVariable>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case PolymodelPackage.POLYHEDRAL_DOMAIN__POLYHEDRA:
				getPolyhedra().clear();
				return;
			case PolymodelPackage.POLYHEDRAL_DOMAIN__PARAMS:
				getParams().clear();
				return;
			case PolymodelPackage.POLYHEDRAL_DOMAIN__EXISTENTIAL:
				getExistential().clear();
				return;
			case PolymodelPackage.POLYHEDRAL_DOMAIN__INDICES:
				getIndices().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case PolymodelPackage.POLYHEDRAL_DOMAIN__POLYHEDRA:
				return polyhedra != null && !polyhedra.isEmpty();
			case PolymodelPackage.POLYHEDRAL_DOMAIN__PARAMS:
				return params != null && !params.isEmpty();
			case PolymodelPackage.POLYHEDRAL_DOMAIN__EXISTENTIAL:
				return existential != null && !existential.isEmpty();
			case PolymodelPackage.POLYHEDRAL_DOMAIN__INDICES:
				return indices != null && !indices.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	public void setDirty() {
		dirty =true;
		
	}

	

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected String toStringList(List<?> list, String separator ) {
		StringBuffer buff = new StringBuffer();
		if(list==null) return "";
		boolean first =true;
		for (Object obj : list) {
			if (first) {
				first =false;
				buff.append(obj.toString());
			} else {
				buff.append(separator+obj.toString());
				
			}
		}
		return buff.toString();
	}

	/**
	 * @generated NOT
	 */
	@Override 
	public String toString() {
		List<String> polyhedra = new LinkedList<String>();
		
		String lhsP = toStringList(this.params, ",");
		String lhsI = toStringList(this.indices, ",");
		String lhs = null;
		if (params.size() > 0 && indices.size() > 0) {
			lhs = lhsP + "," + lhsI;
		} else {
			lhs = lhsP+lhsI;
		}
		if (this.polyhedra == null) {
			return "{"+lhs+"|"+"}";
		}
		for (IntLinearConstraintSystem poly : this.polyhedra) {
			polyhedra.add("{"+lhs+"|"+poly+"}");
		}
		return toStringList(polyhedra, "||");
	}

	@Override
	public List<List<String>> getConstraintList(FORMAT format) {
		List<List<String>> constraintList = new LinkedList<List<String>>();
		for (IntLinearConstraintSystem  ilcs : getPolyhedra()) {
			List<String> consts = new LinkedList<String>();
			for (IntLinearConstraint ilc : ilcs.getLinearConstraints()) {
				consts.add(IntegerLinearAlgebraPrinter.toString(ilc, format));
			}
			constraintList.add(consts);
		}
		return constraintList;
	}
	
	@Override
	public EList<String> getParamNames() {
		EList<String> names = new BasicEList<String>();
		for (IVariable iv : getParams()) {
			names.add(iv.toString());
		}
		return names;
	}

	@Override
	public EList<String> getIndexNames() {
		EList<String> names = new BasicEList<String>();
		for (IVariable iv : getIndices()) {
			names.add(iv.toString());
		}
		return names;
	}


} //PolyhedralDomainImpl
