/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.impl;

import fr.irisa.cairn.model.polymodel.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.IndexDimension;
import fr.irisa.cairn.model.polymodel.Matrix;
import fr.irisa.cairn.model.polymodel.MatrixRow;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.PolyhedralDomainWithScope;
import fr.irisa.cairn.model.polymodel.PolymodelFactory;
import fr.irisa.cairn.model.polymodel.Vertex;
import fr.irisa.cairn.model.polymodel.observer.PolyhedralDomainObserver;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class PolymodelFactoryImpl extends EFactoryImpl implements PolymodelFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static PolymodelFactory init() {
		try {
			PolymodelFactory thePolymodelFactory = (PolymodelFactory)EPackage.Registry.INSTANCE.getEFactory("polymodel"); 
			if (thePolymodelFactory != null) {
				return thePolymodelFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new PolymodelFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolymodelFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case PolymodelPackage.POLYHEDRAL_DOMAIN: return createPolyhedralDomain();
			case PolymodelPackage.POLYHEDRAL_DOMAIN_WITH_SCOPE: return createPolyhedralDomainWithScope();
			case PolymodelPackage.MATRIX: return createMatrix();
			case PolymodelPackage.MATRIX_ROW: return createMatrixRow();
			case PolymodelPackage.AFFINE_MAPPING: return createAffineMapping();
			case PolymodelPackage.AFFINE_MAPPING_WITH_SCOPE: return createAffineMappingWithScope();
			case PolymodelPackage.VERTEX: return createVertex();
			case PolymodelPackage.INDEX_DIMENSION: return createIndexDimension();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public PolyhedralDomain createPolyhedralDomain() {
		PolyhedralDomainImpl polyhedralDomain = new PolyhedralDomainImpl();
		polyhedralDomain.eAdapters().add(new PolyhedralDomainObserver());
		return polyhedralDomain;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public PolyhedralDomainWithScope createPolyhedralDomainWithScope() {
		PolyhedralDomainWithScopeImpl polyhedralDomainWithScope = new PolyhedralDomainWithScopeImpl();
		polyhedralDomainWithScope .eAdapters().add(new PolyhedralDomainObserver());
		return polyhedralDomainWithScope;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Matrix createMatrix() {
		MatrixImpl matrix = new MatrixImpl();
		return matrix;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MatrixRow createMatrixRow() {
		MatrixRowImpl matrixRow = new MatrixRowImpl();
		return matrixRow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AffineMapping createAffineMapping() {
		AffineMappingImpl affineMapping = new AffineMappingImpl();
		return affineMapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AffineMappingWithScope createAffineMappingWithScope() {
		AffineMappingWithScopeImpl affineMappingWithScope = new AffineMappingWithScopeImpl();
		return affineMappingWithScope;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Vertex createVertex() {
		VertexImpl vertex = new VertexImpl();
		return vertex;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IndexDimension createIndexDimension() {
		IndexDimensionImpl indexDimension = new IndexDimensionImpl();
		return indexDimension;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolymodelPackage getPolymodelPackage() {
		return (PolymodelPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static PolymodelPackage getPackage() {
		return PolymodelPackage.eINSTANCE;
	}

} //PolymodelFactoryImpl
