/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;
import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.AffineMappingWithScope;
import fr.irisa.cairn.model.polymodel.IndexDimension;
import fr.irisa.cairn.model.polymodel.Matrix;
import fr.irisa.cairn.model.polymodel.MatrixRow;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.PolyhedralDomainWithScope;
import fr.irisa.cairn.model.polymodel.PolymodelException;
import fr.irisa.cairn.model.polymodel.PolymodelFactory;
import fr.irisa.cairn.model.polymodel.PolymodelPackage;
import fr.irisa.cairn.model.polymodel.Vertex;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class PolymodelPackageImpl extends EPackageImpl implements
		PolymodelPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass polyhedralDomainEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass polyhedralDomainWithScopeEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass matrixEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass matrixRowEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass affineMappingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass affineMappingWithScopeEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass vertexEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass indexDimensionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType ePolymodelExceptionEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see fr.irisa.cairn.model.polymodel.PolymodelPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private PolymodelPackageImpl() {
		super(eNS_URI, PolymodelFactory.eINSTANCE);
	}

	protected PolymodelPackageImpl(PolymodelFactory factory) {
		super(eNS_URI, factory);
	}
	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link PolymodelPackage#eINSTANCE} when
	 * that field is accessed. Clients should not invoke it directly. Instead,
	 * they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static PolymodelPackage init() {
		if (isInited) return (PolymodelPackage)EPackage.Registry.INSTANCE.getEPackage(PolymodelPackage.eNS_URI);

		// Obtain or create and register package
		PolymodelPackageImpl thePolymodelPackage = (PolymodelPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof PolymodelPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new PolymodelPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		IntegerLinearAlgebraPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		thePolymodelPackage.createPackageContents();

		// Initialize created meta-data
		thePolymodelPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		thePolymodelPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(PolymodelPackage.eNS_URI, thePolymodelPackage);
		return thePolymodelPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPolyhedralDomain() {
		return polyhedralDomainEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPolyhedralDomain_Polyhedra() {
		return (EReference)polyhedralDomainEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPolyhedralDomain_Params() {
		return (EReference)polyhedralDomainEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPolyhedralDomain_Existential() {
		return (EReference)polyhedralDomainEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPolyhedralDomain_Indices() {
		return (EReference)polyhedralDomainEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPolyhedralDomainWithScope() {
		return polyhedralDomainWithScopeEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMatrix() {
		return matrixEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMatrix_Rows() {
		return (EReference)matrixEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMatrixRow() {
		return matrixRowEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMatrixRow_Values() {
		return (EAttribute)matrixRowEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAffineMapping() {
		return affineMappingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAffineMapping_Params() {
		return (EReference)affineMappingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAffineMapping_Indices() {
		return (EReference)affineMappingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAffineMapping_Functions() {
		return (EReference)affineMappingEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAffineMappingWithScope() {
		return affineMappingWithScopeEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVertex() {
		return vertexEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getVertex_Denominator() {
		return (EAttribute)vertexEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIndexDimension() {
		return indexDimensionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getIndexDimension_Dimension() {
		return (EAttribute)indexDimensionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getIndexDimension_Name() {
		return (EAttribute)indexDimensionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getEPolymodelException() {
		return ePolymodelExceptionEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public PolymodelFactory getPolymodelFactory() {
		return (PolymodelFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		polyhedralDomainEClass = createEClass(POLYHEDRAL_DOMAIN);
		createEReference(polyhedralDomainEClass, POLYHEDRAL_DOMAIN__POLYHEDRA);
		createEReference(polyhedralDomainEClass, POLYHEDRAL_DOMAIN__PARAMS);
		createEReference(polyhedralDomainEClass, POLYHEDRAL_DOMAIN__EXISTENTIAL);
		createEReference(polyhedralDomainEClass, POLYHEDRAL_DOMAIN__INDICES);

		polyhedralDomainWithScopeEClass = createEClass(POLYHEDRAL_DOMAIN_WITH_SCOPE);

		matrixEClass = createEClass(MATRIX);
		createEReference(matrixEClass, MATRIX__ROWS);

		matrixRowEClass = createEClass(MATRIX_ROW);
		createEAttribute(matrixRowEClass, MATRIX_ROW__VALUES);

		affineMappingEClass = createEClass(AFFINE_MAPPING);
		createEReference(affineMappingEClass, AFFINE_MAPPING__PARAMS);
		createEReference(affineMappingEClass, AFFINE_MAPPING__INDICES);
		createEReference(affineMappingEClass, AFFINE_MAPPING__FUNCTIONS);

		affineMappingWithScopeEClass = createEClass(AFFINE_MAPPING_WITH_SCOPE);

		vertexEClass = createEClass(VERTEX);
		createEAttribute(vertexEClass, VERTEX__DENOMINATOR);

		indexDimensionEClass = createEClass(INDEX_DIMENSION);
		createEAttribute(indexDimensionEClass, INDEX_DIMENSION__DIMENSION);
		createEAttribute(indexDimensionEClass, INDEX_DIMENSION__NAME);

		// Create data types
		ePolymodelExceptionEDataType = createEDataType(EPOLYMODEL_EXCEPTION);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		IntegerLinearAlgebraPackage theIntegerLinearAlgebraPackage = (IntegerLinearAlgebraPackage)EPackage.Registry.INSTANCE.getEPackage(IntegerLinearAlgebraPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		polyhedralDomainWithScopeEClass.getESuperTypes().add(this.getPolyhedralDomain());
		polyhedralDomainWithScopeEClass.getESuperTypes().add(theIntegerLinearAlgebraPackage.getScopeContainer());
		affineMappingWithScopeEClass.getESuperTypes().add(this.getAffineMapping());
		affineMappingWithScopeEClass.getESuperTypes().add(theIntegerLinearAlgebraPackage.getScopeContainer());
		vertexEClass.getESuperTypes().add(this.getMatrixRow());
		indexDimensionEClass.getESuperTypes().add(theIntegerLinearAlgebraPackage.getIVariable());

		// Initialize classes and features; add operations and parameters
		initEClass(polyhedralDomainEClass, PolyhedralDomain.class, "PolyhedralDomain", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPolyhedralDomain_Polyhedra(), theIntegerLinearAlgebraPackage.getIntLinearConstraintSystem(), null, "polyhedra", null, 0, -1, PolyhedralDomain.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPolyhedralDomain_Params(), theIntegerLinearAlgebraPackage.getIVariable(), null, "params", null, 0, -1, PolyhedralDomain.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPolyhedralDomain_Existential(), theIntegerLinearAlgebraPackage.getIVariable(), null, "existential", null, 0, -1, PolyhedralDomain.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPolyhedralDomain_Indices(), theIntegerLinearAlgebraPackage.getIVariable(), null, "indices", null, 0, -1, PolyhedralDomain.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		EOperation op = addEOperation(polyhedralDomainEClass, this.getPolyhedralDomain(), "difference", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getPolyhedralDomain(), "d", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(polyhedralDomainEClass, this.getPolyhedralDomain(), "intersection", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getPolyhedralDomain(), "d", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(polyhedralDomainEClass, this.getPolyhedralDomain(), "union", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getPolyhedralDomain(), "d", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(polyhedralDomainEClass, ecorePackage.getEBoolean(), "equivalence", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getPolyhedralDomain(), "d", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(polyhedralDomainEClass, ecorePackage.getEBoolean(), "isUniverse", 1, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(polyhedralDomainEClass, ecorePackage.getEBoolean(), "isEmpty", 1, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(polyhedralDomainEClass, null, "simplify", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(polyhedralDomainEClass, this.getPolyhedralDomain(), "image", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getAffineMapping(), "T", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(polyhedralDomainEClass, this.getPolyhedralDomain(), "preimage", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getAffineMapping(), "T", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(polyhedralDomainEClass, this.getPolyhedralDomain(), "boundingBox", 1, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(polyhedralDomainEClass, this.getMatrix(), "toMatrices", 0, -1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(polyhedralDomainEClass, null, "addConstraint", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theIntegerLinearAlgebraPackage.getIntLinearConstraint(), "constraint", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(polyhedralDomainEClass, ecorePackage.getEInt(), "getNIndices", 1, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(polyhedralDomainEClass, ecorePackage.getEInt(), "getNParams", 1, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(polyhedralDomainEClass, this.getPolyhedralDomain(), "complement", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(polyhedralDomainWithScopeEClass, PolyhedralDomainWithScope.class, "PolyhedralDomainWithScope", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(matrixEClass, Matrix.class, "Matrix", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMatrix_Rows(), this.getMatrixRow(), null, "rows", null, 0, -1, Matrix.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(matrixEClass, this.getMatrix(), "inverse", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(matrixEClass, this.getMatrix(), "mul", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getMatrix(), "b", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(matrixEClass, this.getMatrix(), "transpose", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(matrixEClass, this.getMatrix(), "identity", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEInt(), "size", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(matrixEClass, this.getMatrix(), "findHermiteBasis", 2, 2, IS_UNIQUE, IS_ORDERED);

		addEOperation(matrixEClass, ecorePackage.getEBoolean(), "isUnimodular", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(matrixEClass, ecorePackage.getEBoolean(), "isInHNF", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(matrixEClass, ecorePackage.getEBoolean(), "isIntegral", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(matrixEClass, this.getMatrix(), "left_hermite", 0, -1, IS_UNIQUE, IS_ORDERED);

		addEOperation(matrixEClass, ecorePackage.getEBoolean(), "isIdentity", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(matrixEClass, ecorePackage.getEBoolean(), "isSquare", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(matrixRowEClass, MatrixRow.class, "MatrixRow", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMatrixRow_Values(), ecorePackage.getELongObject(), "values", null, 0, -1, MatrixRow.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(matrixRowEClass, ecorePackage.getEInt(), "getSize", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(matrixRowEClass, ecorePackage.getEString(), "toConstraint", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "names", 0, -1, IS_UNIQUE, IS_ORDERED);

		initEClass(affineMappingEClass, AffineMapping.class, "AffineMapping", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAffineMapping_Params(), theIntegerLinearAlgebraPackage.getIVariable(), null, "params", null, 0, -1, AffineMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAffineMapping_Indices(), theIntegerLinearAlgebraPackage.getIVariable(), null, "indices", null, 0, -1, AffineMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAffineMapping_Functions(), theIntegerLinearAlgebraPackage.getIntLinearExpression(), null, "functions", null, 0, -1, AffineMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		op = addEOperation(affineMappingEClass, this.getAffineMapping(), "compose", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getAffineMapping(), "f2", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(affineMappingEClass, ecorePackage.getEBoolean(), "equivalence", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getAffineMapping(), "func", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(affineMappingEClass, this.getAffineMapping(), "inverseInContext", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getPolyhedralDomain(), "context", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "names", 0, -1, IS_UNIQUE, IS_ORDERED);
		addEException(op, this.getEPolymodelException());

		addEOperation(affineMappingEClass, this.getMatrix(), "toMatrix", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(affineMappingEClass, this.getAffineMapping(), "toAffineMapping", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getMatrix(), "matrix", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theIntegerLinearAlgebraPackage.getIVariable(), "params", 0, -1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theIntegerLinearAlgebraPackage.getIVariable(), "indices", 0, -1, IS_UNIQUE, IS_ORDERED);

		addEOperation(affineMappingEClass, ecorePackage.getEInt(), "getDimRHS", 1, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(affineMappingEClass, ecorePackage.getEInt(), "getDimLHS", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(affineMappingWithScopeEClass, AffineMappingWithScope.class, "AffineMappingWithScope", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(vertexEClass, Vertex.class, "Vertex", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getVertex_Denominator(), ecorePackage.getEInt(), "denominator", null, 0, 1, Vertex.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(indexDimensionEClass, IndexDimension.class, "IndexDimension", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getIndexDimension_Dimension(), ecorePackage.getEInt(), "dimension", null, 0, 1, IndexDimension.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getIndexDimension_Name(), ecorePackage.getEString(), "name", null, 0, 1, IndexDimension.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize data types
		initEDataType(ePolymodelExceptionEDataType, PolymodelException.class, "EPolymodelException", !IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} // PolymodelPackageImpl
