package fr.irisa.cairn.model.polymodel.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.PolymodelFactory;
import fr.irisa.cairn.model.polymodel.PolymodelPackage;

public class PolymodelSerializer {


	public static void serialize(PolyhedralDomain domain, String file) {
		ResourceSet rs = new ResourceSetImpl();
		Resource.Factory.Registry f = rs.getResourceFactoryRegistry();
		Map<String, Object> m = f.getExtensionToFactoryMap();
		m.put("polymodel", new XMIResourceFactoryImpl());
		rs.getPackageRegistry().put(PolymodelPackage.eNS_URI, PolymodelPackage.eINSTANCE);

		Resource packageResource = rs.createResource(URI
				.createFileURI(file));
		packageResource.getContents().add(PolymodelPackage.eINSTANCE);
		try {
			packageResource.load(null);
		} catch (IOException e1) {
			e1.printStackTrace();
		}

		URI uri = URI.createFileURI(file);
		Resource resource = rs.createResource(uri);
		resource.getContents().add(domain);
		try {
			HashMap<String, Object> options = new HashMap<String, Object>();
			options.put(XMIResource.OPTION_SCHEMA_LOCATION, Boolean.TRUE);

			resource.save(options);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Unserialize a domain using a given factory.
	 * 
	 * @param file
	 * @param factory
	 * @return
	 */
	public static PolyhedralDomain unserialize(String file, PolymodelFactory factory) {
		ResourceSet rs = new ResourceSetImpl();
		Resource.Factory.Registry f = rs.getResourceFactoryRegistry();
		Map<String, Object> m = f.getExtensionToFactoryMap();
		m.put("polymodel", new XMIResourceFactoryImpl());
		rs.getPackageRegistry().put(PolymodelPackage.eNS_URI,
				PolymorphPolymodelPackage.instance(factory));
		URI uri = URI.createFileURI(file);
		Resource resource = rs.getResource(uri, true);
		PolyhedralDomain myPs = null;
		if (resource.isLoaded() && resource.getContents().size() > 0) {
			myPs = (PolyhedralDomain) resource.getContents().get(0);
		}
		return myPs;
	}

	/**
	 * Unserialize a domain using default emf {@link PolymodelFactory}.
	 * 
	 * @param file
	 * @return
	 */
	public static PolyhedralDomain unserialize(String file) {
		return unserialize(file, PolymodelFactory.eINSTANCE);
	}
}
