package fr.irisa.cairn.model.polymodel.io;

import java.util.Map;

import fr.irisa.cairn.model.polymodel.PolymodelFactory;
import fr.irisa.cairn.model.polymodel.PolymodelPackage;
import fr.irisa.cairn.model.polymodel.impl.PolymodelPackageImpl;

/**
 * A package which can use different factories.
 * 
 * @author antoine
 * 
 */
class PolymorphPolymodelPackage extends PolymodelPackageImpl {
	private static Map<PolymodelFactory, PolymorphPolymodelPackage> instances;

	/**
	 * Get the singleton instance of the package for a given factory.
	 * 
	 * @param factory
	 * @return
	 */
	public static PolymodelPackage instance(PolymodelFactory factory) {
		if (factory == PolymodelFactory.eINSTANCE)
			return PolymodelPackage.eINSTANCE;
		PolymorphPolymodelPackage instance = instances.get(factory);
		if (instance == null) {
			instance = new PolymorphPolymodelPackage(factory);
			instances.put(factory, instance);
		}
		return instance;
	}

	protected PolymorphPolymodelPackage(PolymodelFactory factory) {
		super(factory);
	}

}
