package fr.irisa.cairn.model.polymodel.observer;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;

import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl;
/**
 * This observe class is used to mark a PolyedronImpl object as dirty, whenever 
 * one of its constraints changes. this ensures consistency between the object 
 * and its Polylib proxy which is cached in the implementation.    
 * @author sderrien
 *
 */
public class PolyhedralDomainObserver extends EContentAdapter  {

	public void notifyChanged(Notification notification) {
		super.notifyChanged(notification);
		if (notification!=null && !notification.isTouch()) {
			EObject target = (EObject) notification.getNotifier();
			while((target != null) & (!(target instanceof PolyhedralDomain))) {
				target = target.eContainer();
			}
			if (target==null) {
				throw new RuntimeException("Inconsistency in PolyhedralDomain observer");
			} else {
				PolyhedralDomainImpl object = (PolyhedralDomainImpl) target;
				object.setDirty();
			}
		}
	}

}
