package fr.irisa.cairn.model.polymodel.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;

import fr.irisa.cairn.model.integerLinearAlgebra.IPrettyPrint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntMaxExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntMinExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntProdExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntSumExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.Scope;
import fr.irisa.cairn.model.integerLinearAlgebra.util.IntegerLinearAlgebraSwitch;
import fr.irisa.cairn.model.polymodel.IndexDimension;

public class IntegerLinearAlgebraPrinter extends IntegerLinearAlgebraSwitch<String> {
	
	private static Map<FORMAT, IntegerLinearAlgebraPrinter> _instances = new HashMap<FORMAT, IntegerLinearAlgebraPrinter>();
	
	public static enum FORMAT {
		ISL,
		ALPHABETS,
		C
	}
	
	protected final List<String> names;
	protected final FORMAT format;
	protected final boolean useNames;
	
	public static String toString(EObject obj, FORMAT format) {
		if (!_instances.containsKey(format)) {
			_instances.put(format, new IntegerLinearAlgebraPrinter(format));
		}
		return _instances.get(format).doSwitch(obj);
	}
	
	public static String toString(EObject obj, FORMAT format, List<String> names) {
		return new IntegerLinearAlgebraPrinter(format, names).doSwitch(obj);
	}
	protected IntegerLinearAlgebraPrinter(FORMAT format) {
		this.format = format;
		this.names = null;
		useNames = false;
	}
	
	protected IntegerLinearAlgebraPrinter(FORMAT format, List<String> names) {
		this.format = format;
		this.names = names;
		useNames = true;
	}
	
	@Override
	public String defaultCase(EObject object) {
		throw new RuntimeException("Unexpected case :"  +object.getClass());
	}
	
	@Override
	public String caseIntConstraintSystem(IntConstraintSystem o) {
		StringBuffer buf = new StringBuffer();
		boolean first=true;
		for (IntConstraint ic : o.getConstraints()) {
			buf.append((first?"":" && ")+doSwitch(ic));
			first=false;
		}
		return buf.toString();
	}
	
	@Override
	public String caseIntLinearConstraintSystem(IntLinearConstraintSystem o) {
		StringBuffer buf = new StringBuffer();
		boolean first=true;
		for (IntLinearConstraint ilc : o.getLinearConstraints()) {
			buf.append((first?"":" && ")+doSwitch(ilc));
			first=false;
		}
		return buf.toString();
	}
	
	@Override
	public String caseIntTermExpression(IntTermExpression o) {
		if (o.getValue() == 0) return "0";
		StringBuffer buf = new StringBuffer();
		if (o.getValue() < 0) {
			buf.append("-");
		}
		int abs = Math.abs(o.getValue());
		if (o.getVar() == null) {
			buf.append(abs);
		} else {
			if (abs==1) {
				
			} else {
				buf.append(abs+"*");
			}
			String name ="";
			if (useNames && o.getVar() instanceof IndexDimension) {
				name = ((IndexDimension)o.getVar()).getDimName(names);
			} else {
				name = o.getVar().toString();
			}
			if(name.toUpperCase().equals("MAX") || name.toUpperCase().equals("MIN")) {
				name="_"+name;
			}
			buf.append(name);

		}
		return buf.toString();
	}
	
	@Override
	public String caseIntSumExpression(IntSumExpression o) {
		return separate((o.getTerms()), "+").replaceAll("\\+\\-", "\\-");
	}

	@Override
	public String caseIntProdExpression(IntProdExpression o) {
		return separate((o.getTerms()), "*").replaceAll("\\+\\-", "\\-");
	}

	@Override
	public String caseIntMaxExpression(IntMaxExpression o) {
		return separate((o.getTerms()), "max").replaceAll("\\+\\-", "\\-");
	}

	@Override
	public String caseIntMinExpression(IntMinExpression o) {
		return separate((o.getTerms()), "min").replaceAll("\\+\\-", "\\-");
	}
	
	@Override
	public String caseIntConstraint(IntConstraint o) {
		switch (o.getComparisonOperator().ordinal()) {
		case Operator.EQ_VALUE:
			switch (format) {
				case ISL:
					return "" +doSwitch(o.getExpr()) + "= 0";
				case ALPHABETS:
				case C:
					return "" +doSwitch(o.getExpr()) + "== 0";		
			}	
		case Operator.GT_VALUE:
			return "" +doSwitch(o.getExpr()) + "> 0";			
		case Operator.GE_VALUE:
			return "" +doSwitch(o.getExpr()) + ">= 0";			
		case Operator.LE_VALUE:
			return "" +doSwitch(o.getExpr()) + "<= 0";			
		case Operator.LT_VALUE:
			return "" +doSwitch(o.getExpr()) + "< 0";			
		default:
			return "" +doSwitch(o.getExpr()) + "("+o.getComparisonOperator()+") 0";			
		}
	}
	
	public String separate(List<IntExpression> exprs, String sep) {
		StringBuffer buf = new StringBuffer();
		boolean first=true;
		for (IPrettyPrint expr : exprs) {
			buf.append((first?"":sep)+doSwitch(expr));
			first=false;
		}
		return buf.toString();
	}
}
