package fr.irisa.cairn.model.polymodel.isl.factory;



import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

import fr.irisa.cairn.jnimap.isl.jni.ISLPrettyPrinter.ISL_FORMAT;
import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLBasicMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLBasicSet;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDimType;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMatrix;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSpace;
import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;
import fr.irisa.cairn.model.integerLinearAlgebra.tom.Isolate;
import fr.irisa.cairn.model.integerLinearAlgebra.util.IntExpressionQuery;
import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.Matrix;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.factory.PolyModelDefaultFactory;
import fr.irisa.cairn.model.polymodel.isl.ISLMap;
import fr.irisa.cairn.model.polymodel.isl.ISLSet;

public class ISLDefaultFactory extends PolyModelDefaultFactory {
	
	public final static ISLDefaultFactory INSTANCE = new ISLDefaultFactory();

	protected ISLDefaultFactory() {
		super(ISLFactoryProxy.INSTANCE);
	}
 
	private ISLSet parsePolyLibString(JNIISLBasicSet set, List<? extends IVariable> params, List<? extends IVariable> indices) {
		return parsePolyLibString("1\n\n"+set.toString(ISL_FORMAT.POLYLIB), params, null,indices);
	}
	
	private ISLSet parsePolyLibString(JNIISLSet set, List<IVariable> params, List<IVariable> indices) {
		return parsePolyLibString(set.toString(ISL_FORMAT.POLYLIB), params, null, indices);
	}

	public  ISLSet parsePolyLibString(String polylibformat, List<? extends IVariable> params, List<? extends IVariable> existential, List<? extends IVariable> indices) {
		//List of indices
		List<String> ids = new LinkedList<String>();
		
		for (IVariable param : params) {
			ids.add(param.toString());
		}
		for (IVariable id : indices) {
			ids.add(id.toString());
		}

		if(existential!=null)
			for (IVariable exist : existential) {
				ids.add(exist.toString());
			}

		String[] lines = polylibformat.split("\n");
		int numP = Integer.parseInt(lines[0]);
		//Empty polyhedron
		int current = 2;
		List<List<String>> constraintsList = new LinkedList<List<String>>();
		if (numP == 0) {
			List<String> empty = new LinkedList<String>();
			empty.add("1=0");
			constraintsList.add(empty);
			return polyhedralDomain(params, indices, constraintsList);
		}
		

		
		//Parse constraints
		boolean firstPolyhedron = true;
		while (lines.length > current) {
			List<String> constraints = new LinkedList<String>();
			//Parse the first row of polyhedron, defining the size
			String[] polySize = lines[current].split("\\s+");
			int numRow = Integer.parseInt(polySize[0]);
			int numCol = Integer.parseInt(polySize[1]);
			current++;
			
			//Initialization for first polyhedron
			if (firstPolyhedron) {
				firstPolyhedron = false;
				//Remove/Add dimensions based on the column size
				//Extra dimensions
				while (ids.size() > numCol-2) {
					ids.remove(ids.size()-1);
				}
				//Additional dimensions
				for (int d = ids.size(); d < numCol-2; d++) {
					ids.add("i"+d);
				}
			}
			//Parse the rows of polyhedron
			for (int i = 0; i < numRow; i++) {
				String[] cols = lines[current].split("\\s+");
				//Initialize the String with the constant part
				StringBuffer expr = new StringBuffer();
				if(cols[cols.length-1].compareTo("0") != 0) {
					expr.append(cols[cols.length-1]);
				}
				
				int existsSize=0;
				if(existential!=null) {
					existsSize=existential.size();
				}
				
				int indicesSize = cols.length -2 - params.size() - existsSize;
				
				int paramStartIndex = 1+ indicesSize + existsSize;
				//Parameters
				for (int c = 0; c < params.size(); c++) {
					expr.append(polyLibBuildTerm(ids.subList(0, params.size()), c, cols[c+paramStartIndex]));
				}
				
				int indicesStartIndex = 1;
				//Indices
				for (int c = 0; c < indicesSize; c++) {
					expr.append(polyLibBuildTerm(ids.subList(params.size(), params.size()+indicesSize), c, cols[c+indicesStartIndex]));
				}

				int existStartIndex = 1+ indicesSize ;
				// Existential div
				for (int c = 0; c <  existsSize; c++) {
					expr.append(polyLibBuildTerm(ids.subList(params.size()+indicesSize,ids.size()), c, cols[c+existStartIndex]));
				}


				//Equality or not
				if (Integer.parseInt(cols[0]) == 0) {
					constraints.add(expr + "= 0");
				} else {
					constraints.add(expr + ">= 0");
				}
				current++;
			}
			constraintsList.add(constraints);
			current++;
		}
		
		return polyhedralDomainUnionFromString(ids, params.size(), constraintsList);
	}

	private String polyLibBuildTerm(List<String> ids, int pos, String string) {
		int coef = Integer.parseInt(string);
		if (coef != 0) {
			String term = ids.get(pos);
			if (coef == 1) {
				return ("+("+term+")");
			} else if (coef == -1) {
				return ("+(-"+term+")");
			} else {
				return ("+("+coef+term+")");
			}
		}
		return "";
	}
	
	public PolyhedralDomain polyhedralDomain(JNIISLSet set, PolyhedralDomain origDomain) {
		int dim = Math.min((int) set.getNDim(), origDomain.getIndices().size());
		//copy IVariables from the original domain as much as possible
		List<IVariable> indices = new ArrayList<IVariable>(dim);
		List<IVariable> subList = origDomain.getIndices().subList(0, dim);
		for (IVariable v : subList) {
			indices.add(v.copy());
		}
		//add dimensions that are missing in the original domain
		for (int d = indices.size(); d < set.getNDim(); d++) {
			indices.add(INSTANCE.createIndexDimension(d, "i"+d));
		}
		return parsePolyLibString(set, origDomain.getParams(), indices);
	}
	
	public ISLSet polyhedralDomain(JNIISLBasicSet set, List<? extends IVariable> params, List<? extends IVariable> indices) {
		return parsePolyLibString(set, params, indices);
	}
	
	public ISLSet polyhedralDomain(JNIISLBasicSet set, PolyhedralDomain origDomain) {
		return parsePolyLibString(set, origDomain.getParams(), origDomain.getIndices());
	}
	
	public ISLSet polyhedralDomain(JNIISLSet set, List<IVariable> params, List<IVariable> indices) {
		return parsePolyLibString(set, params, indices);
	}
	
	public ISLSet polyhedralDomainFromMap(JNIISLMap map,  List<IVariable> params, List<IVariable> indices) {
		return parsePolyLibString(map.toString(ISL_FORMAT.POLYLIB), params, null, indices);
	}


	
	public static IntConstraintSystem quasiAffineSystem(JNIISLBasicMap map, List<IVariable> params, List<IVariable> inIndices,List<IVariable> outIndices) {
		JNIISLMatrix m = map.copy().toEqualityMatrix(
				JNIISLDimType.isl_dim_param, 
				JNIISLDimType.isl_dim_in, 
				JNIISLDimType.isl_dim_out, 
				JNIISLDimType.isl_dim_cst,
				JNIISLDimType.isl_dim_div 
				);
		IntConstraintSystem constraintSystem = matrixToConstraintSystem(params,
				inIndices, outIndices, m);
		
		return constraintSystem;
	}

	public static List<IntExpression> toRHSExpressions(JNIISLBasicMap map, List<IVariable> params, List<IVariable> inIndices,List<IVariable> outIndices) {
		JNIISLMatrix m = map.copy().toEqualityMatrix(
				JNIISLDimType.isl_dim_param, 
				JNIISLDimType.isl_dim_in, 
				JNIISLDimType.isl_dim_out, 
				JNIISLDimType.isl_dim_cst,
				JNIISLDimType.isl_dim_div 
				);
		IntConstraintSystem constraintSystem = matrixToConstraintSystem(params,inIndices, outIndices, m);
		
		return builIntExpressionList(outIndices, constraintSystem);
	}

	private static IntConstraintSystem matrixToConstraintSystem(
			List<IVariable> params, List<IVariable> inIndices,
			List<IVariable> outIndices, JNIISLMatrix m) {
		IntConstraintSystem constraintSystem = IntegerExpressionUserFactory.constraintSystem();
		for(int i=0;i<m.getNbRows();i++) {
			IntExpression exp = matrixRowToIntExpression(params, inIndices,	outIndices, m, i);
			IntConstraint constraint = IntegerExpressionUserFactory.constraint(exp, Operator.EQ);
			constraintSystem.getConstraints().add(constraint);
		}
		return constraintSystem;
	}

	private static List<IntExpression> builIntExpressionList(	List<IVariable> outIndices,
			IntConstraintSystem constraintSystem) {
		List<IntExpression> res= new ArrayList<IntExpression>();
		for (IVariable var : outIndices) {
			int found =0;
			for(IntConstraint constraint : constraintSystem.getConstraints()) { 
				IntExpression expr = constraint.getExpr().simplify();
				if(IntExpressionQuery.containsVar(expr,var)) {
					found++;
					expr = Isolate.isolate(expr, var);
					if(found>1 ) {
						throw new UnsupportedOperationException("Warning : more than one assignment for index "+var+" in "+constraintSystem);
					}
					if(expr==null) {
						throw new UnsupportedOperationException("Error in Isolate("+expr+")");
					}
					res.add(expr);
				}
			}
		}
		return res;
	}

	public static List<IntExpression> toRHSExpressions(JNIISLBasicSet set, List<IVariable> params, List<IVariable> inIndices) {
		
		JNIISLMatrix m = set.copy().toEqualityMatrix(
				JNIISLDimType.isl_dim_param, 
				JNIISLDimType.isl_dim_set, 
				JNIISLDimType.isl_dim_cst,
				JNIISLDimType.isl_dim_div 
				);
			
		IntConstraintSystem constraintSystem = IntegerExpressionUserFactory.constraintSystem();
		for(int i=0;i<m.getNbRows();i++) {
			IntExpression exp = matrixRowToIntExpression(params, inIndices,	null, m, i);
			IntConstraint constraint = IntegerExpressionUserFactory.constraint(exp, Operator.EQ);
			constraintSystem.getConstraints().add(constraint);
		}
		
		return builIntExpressionList(inIndices, constraintSystem);
	}

	public static IntConstraintSystem basicSetToConstraintSystem(JNIISLBasicSet set, List<IVariable> params, List<IVariable> inIndices) {
		IntConstraintSystem constraintSystem = IntegerExpressionUserFactory.constraintSystem();
		JNIISLMatrix m = set.toEqualityMatrix(
				JNIISLDimType.isl_dim_param, 
				JNIISLDimType.isl_dim_set, 
				JNIISLDimType.isl_dim_cst,
				JNIISLDimType.isl_dim_div 
				);
		for(int i=0;i<m.getNbRows();i++) {
			IntExpression exp = matrixRowToIntExpression(params, inIndices,	null, m, i);
			IntConstraint constraint = IntegerExpressionUserFactory.constraint(exp, Operator.EQ);
			constraintSystem.getConstraints().add(constraint);
		}
		m = set.toInequalityMatrix(
				JNIISLDimType.isl_dim_param, 
				JNIISLDimType.isl_dim_set, 
				JNIISLDimType.isl_dim_cst,
				JNIISLDimType.isl_dim_div 
				);
		for(int i=0;i<m.getNbRows();i++) {
			IntExpression exp = matrixRowToIntExpression(params, inIndices,	null, m, i);
			IntConstraint constraint = IntegerExpressionUserFactory.constraint(exp, Operator.LE);
			constraintSystem.getConstraints().add(constraint);
		}
		return constraintSystem;
	}

	private static IntLinearExpression matrixRowToLinearExpression(List<IVariable> params, List<IVariable> inIndices,List<IVariable> outIndices, JNIISLMatrix m, int i) {
		
		int instart= params.size();
		int outstart= instart + inIndices.size();
		int cststart= outstart+ outIndices.size();
		int divstart= cststart+1;
		if(divstart<=m.getNbCols()) 
			throw new UnsupportedOperationException("This is not an affine expression");
		IntExpression exp =IntegerExpressionUserFactory.term(0);
		for(int j=0;j<m.getNbCols();j++) {
			int val = m.getAt(i,j);
			if(val!=0) {
				IntTermExpression term; 
				if(j<instart) {
					term = term(val,params.get(j));
				} else if(j<outstart) {
					term = term(val,inIndices.get(j-instart));
				} else if(j<cststart) {
					term = term(val,outIndices.get(j-outstart));
				} else if(j<divstart) {
					term = term(val);
				} else {
					throw new UnsupportedOperationException("This is not an affine expression");
				}
				exp=add(exp, term);
			}
			
		}
		return linexp(exp);
	}

	private static IntExpression matrixRowToIntExpression(
			List<IVariable> params, List<IVariable> inIndices,
			List<IVariable> outIndices, JNIISLMatrix m, int i) {
		IntExpression exp =IntegerExpressionUserFactory.term(0);
		
		int instart= params.size();
		int outstart= instart + inIndices.size();
		int osize =0;
		if(outIndices!=null)
			osize= outIndices.size();
		int cststart= outstart+ osize;
		int divstart= cststart+1;
		for(int j=0;j<m.getNbCols();j++) {
			int val = m.getAt(i,j);
			if(val!=0) {
				IntTermExpression term ;
				if(j<instart) {
					term = term(val,params.get(j));
				} else if(j<outstart) {
					term = term(val,inIndices.get(j-instart));
				} else if(j<cststart) {
					term = term(val,outIndices.get(j-outstart));
				} else if(j<divstart) {
					term = term(val);
				} else  {
					throw new UnsupportedOperationException("Not yet implemented");
					//term = term(val,divIndices.get(j-divstart));
				}
				exp=IntegerExpressionUserFactory.add(exp, term);
			}
			
		}
		return exp;
	}
		
	
	/**
	 * Converts back JNIISLMap object to AffineMapping using the params/indices given.
	 * 
	 * @param params
	 * @param indices
	 * @param map
	 * @return
	 */ 
	public AffineMapping affineMapping(JNIISLMap map, List<IVariable> params, List<IVariable> indices) {
		String islText = map.toString(ISL_FORMAT.POLYLIB); 
		String[] lines = islText.split("\r|\n");

		String[] sizeRow = lines[2].split("\\s+");
		int nRow = Integer.parseInt(sizeRow[0]);
		int lhsDim = (int)map.getNbDim(JNIISLDimType.isl_dim_in);
		int rhsDim = (int)map.getNbDim(JNIISLDimType.isl_dim_out);
		//Create indices
		List<String> ids = new LinkedList<String>();
		//Parameters are after indices in polylib format
		for (IVariable i : indices) {
			ids.add(i.toString());
		}
		for (IVariable p : params) {
			ids.add(p.toString());
		}
		
		//Initialize expression list with the number of dimensions
		List<String> expressions = new Vector<String>(nRow);
		for (int i = 0; i < nRow; i++) {
			expressions.add("");
		}
		//Construct expressions from poly lib format
		for (int r = 0 ; r < nRow; r++) {
			String[] row = lines[3+r].split("\\s+");
			//skip domain constraints
			if (Integer.parseInt(row[0]) == 1) {
				continue;
			}
			int exprColStart = rhsDim + 1; //1 is for the eq/ineq in the head
			StringBuffer expr = new StringBuffer("0");
			//Turn polylib matrix into strings
			
			//Find out which dimension this row is about
			//ISL output does not guarantee any ordering
			int dim = -1;
			boolean negate = false;
			for (int i = 0; i < rhsDim; i++) {
				if (Integer.parseInt(row[1+i]) != 0) {
					dim = i;
					//if the target is 1, all other columns have to be negated
					if (Integer.parseInt(row[1+i]) == 1) {
						negate = true;
					}
					break;
				}
			}
			//if the equality does not correspond to the function, ignore
			if (dim == -1) continue;
			
			//Parameters eq/en indices params 1
			for (int i = exprColStart; i < row.length-1; i++) {
				String id = ids.get(i-exprColStart);
				if (Integer.parseInt(row[i]) != 0) {
					if (negate) {
						expr.append("-("+row[i]+id+")");
					} else {
						expr.append("+("+row[i]+id+")");
					}
				}
			}
			//Constant part
			if (negate) {
				expr.append("-"+row[row.length-1]);
			} else {
				expr.append("+"+row[row.length-1]);
			}
			expressions.set(dim,expr.toString());
		}
		return this.affineMapping(params, indices, expressions);
	}

	@Override
	public ISLSet polyhedralDomainFromString(List<String> ids,
			int numParams, List<String> constraints) {

		return (ISLSet) super.polyhedralDomainFromString(ids, numParams, constraints);
	}

	@Override
	public ISLSet polyhedralDomainFromString(List<String> params,
			List<String> ids, List<String> constraints) {

		return (ISLSet) super.polyhedralDomainFromString(params, ids, constraints);
	}

	@Override
	public ISLSet polyhedralDomainUnionFromString(List<String> ids,
			int numParams, List<List<String>> constraintsList) {

		return (ISLSet) super.polyhedralDomainUnionFromString(ids, numParams, constraintsList);
	}

	@Override
	public ISLSet polyhedralDomainUnionFromString(
			List<String> params, List<String> ids,
			List<List<String>> constraintsList) {

		return (ISLSet) super.polyhedralDomainUnionFromString(params, ids, constraintsList);
	}

	@Override
	public ISLSet polyhedralDomain(List<? extends IVariable> params,
			List<? extends IVariable> indices, List<List<String>> constraintList) {

		return (ISLSet) super.polyhedralDomain(params, indices, constraintList);
	}

	@Override
	public ISLSet polyhedralDomain(
			IntLinearConstraintSystem... systems) {

		return (ISLSet) super.polyhedralDomain(systems);
	}

	@Override
	public ISLSet polyhedralDomainWithScope(List<IVariable> indexes,
			List<IVariable> params) {

		return (ISLSet) super.polyhedralDomainWithScope(indexes, params);
	}
	
	/***************************************************************** 
	 * 
	 *  ISL String Interface
	 * 
	 *****************************************************************/
	
	public ISLSet polyhedralDomainFromISLString(String islStr) {

		JNIISLSet set = ISLFactory.islSet(islStr);
		List<IVariable> params = toIndexDimensions(0, set.getParametersNames());
		List<IVariable> indices = toIndexDimensions(params.size(), set.getIndicesNames());
		
		return polyhedralDomain(set, params, indices);
	}

	public AffineMapping affineMappingFromISLString(String islStr) {

		JNIISLMap map = ISLFactory.islMap(islStr);
		List<IVariable> params = toIndexDimensions(0, map.getParametersNames());
		List<IVariable> indices = toIndexDimensions(params.size(), map.getDomainNames());
		
		return affineMapping(map, params, indices);
	}

	private static List<IVariable> toIndexDimensions(int startingDim, List<String> names) {
		int dim = startingDim;
		List<IVariable> vars = new ArrayList<IVariable>(names.size());
		for (String name : names) {
			vars.add(ISLDefaultFactory.INSTANCE.createIndexDimension(dim, name));
			dim++;
		}
		return vars;
	}
	
	/*****************************
	 *  END ISL String interface
	 *****************************/
	
	public ISLSet polyhedralDomainWithScope(JNIISLSet set) {
		List<IVariable> indexes = new ArrayList<IVariable>();
		List<IVariable> existential = new ArrayList<IVariable>();
		List<IVariable> params = new ArrayList<IVariable>();
		
		JNIISLSpace dimensions = set.getSpace();
		
		for(int i =0 ;i <dimensions.getSize(JNIISLDimType.isl_dim_set); i++) {
			String name = dimensions.getName(JNIISLDimType.isl_dim_set, i);
			indexes.add(IntegerExpressionUserFactory.var(name));
		}

		for(int i =0 ;i <dimensions.getSize(JNIISLDimType.isl_dim_param); i++) {
			String name = dimensions.getName(JNIISLDimType.isl_dim_param, i);
			params.add(IntegerExpressionUserFactory.var(name));
		}

		ISLSet polyhedralDomainWithScope = (ISLSet) super.polyhedralDomainWithScope(indexes, params);

		for(int i =0 ;i <dimensions.getSize(JNIISLDimType.isl_dim_div); i++) {
			String name = dimensions.getName(JNIISLDimType.isl_dim_div, i);
			polyhedralDomainWithScope.getExists().add(IntegerExpressionUserFactory.var(name));
		}

		

		return polyhedralDomainWithScope;
		
	}


	@Override
	public ISLSet domain() {

		return (ISLSet) super.domain();
	}

	@Override
	public ISLSet domain(List<IntLinearConstraintSystem> systems) {
		
		return (ISLSet) super.domain(systems);
	}


	@Override
	public ISLSet domain(List<IntLinearConstraintSystem> systems,
			List<? extends IVariable> vars, List<? extends IVariable> params) {

		return (ISLSet) super.domain(systems, vars, params);
	}

	@Override
	public ISLSet domain(List<? extends IVariable> vars,
			List<? extends IVariable> params) {

		return (ISLSet) super.domain(vars, params);
	}

	@Override
	public ISLSet domain(IntLinearConstraintSystem system,
			List<? extends IVariable> vars, List<? extends IVariable> params) {

		return (ISLSet) super.domain(system, vars, params);
	}

	@Override
	public ISLSet domain(IntLinearConstraintSystem system,
			List<? extends IVariable> vars, int nbparam) {

		return (ISLSet) super.domain(system, vars, nbparam);
	}

	@Override
	public ISLSet domainFromMatrix(List<Matrix> matrices,
			List<? extends IVariable> vars, List<? extends IVariable> params) {

		return (ISLSet) super.domainFromMatrix(matrices, vars, params);
	}

	@Override
	public ISLSet domainFromMatrix(List<Matrix> matrices,
			List<? extends IVariable> vars, int nbparam) {

		return (ISLSet) super.domainFromMatrix(matrices, vars, nbparam);
	}

}
