package fr.irisa.cairn.model.polymodel.isl.factory;

import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.AffineMappingWithScope;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.PolyhedralDomainWithScope;
import fr.irisa.cairn.model.polymodel.impl.PolymodelFactoryImpl;
import fr.irisa.cairn.model.polymodel.isl.IslFactory;

class ISLFactoryProxy  extends PolymodelFactoryImpl {
	public final static ISLFactoryProxy INSTANCE = new ISLFactoryProxy();


	/**
	 * Create a {@link PolylibDomain}
	 */
	@Override
	public PolyhedralDomain createPolyhedralDomain() {
		return IslFactory.eINSTANCE.createISLSet();
	}

	@Override
	public PolyhedralDomainWithScope createPolyhedralDomainWithScope() {
		return IslFactory.eINSTANCE.createISLSetWithScope();
	}
	
	@Override
	public AffineMapping createAffineMapping() {
		return IslFactory.eINSTANCE.createISLMap();
	}
	
	@Override
	public AffineMappingWithScope createAffineMappingWithScope() {
		return IslFactory.eINSTANCE.createISLMapWithScope();
	}
	

}
