/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.isl.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;

import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.ISLPrettyPrinter.ISL_FORMAT;
import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.Matrix;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.PolymodelException;
import fr.irisa.cairn.model.polymodel.factory.PolyModelDefaultFactory;
import fr.irisa.cairn.model.polymodel.impl.AffineMappingImpl;
import fr.irisa.cairn.model.polymodel.isl.ISLMap;
import fr.irisa.cairn.model.polymodel.isl.ISLPWQPolynomial;
import fr.irisa.cairn.model.polymodel.isl.IslPackage;
import fr.irisa.cairn.model.polymodel.isl.factory.ISLDefaultFactory;
import fr.irisa.cairn.model.polymodel.util.PolyModelToISLString;
import fr.irisa.cairn.model.polymodel.util.PolyModelToISLString.NAMING_SCHEME;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>ISL Map</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class ISLMapImpl extends AffineMappingImpl implements ISLMap {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISLMapImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IslPackage.Literals.ISL_MAP;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AffineMapping reverse() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISLPWQPolynomial card() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isBijective() {
		JNIISLMap map = ISLFactory.islMap(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		return map.isBijective() != 0;
	}

	@Override
	public AffineMapping compose(AffineMapping f2) {
		JNIISLMap map1 = ISLFactory.islMap(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLMap map2 = ISLFactory.islMap(PolyModelToISLString.toString(f2, NAMING_SCHEME.DIMENSIONS));
		JNIISLMap mapC = JNIISLMap.applyRange(map2, map1);
		//Preserve old names for the LHS
		return ISLDefaultFactory.INSTANCE.affineMapping(mapC, f2.getParams(), f2.getIndices());
	}
	
	@Override
	public boolean equivalence(AffineMapping func) {
		JNIISLMap map1 = ISLFactory.islMap(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLMap map2 = ISLFactory.islMap(PolyModelToISLString.toString(func, NAMING_SCHEME.DIMENSIONS));
		if (map1.getNbIn() != map2.getNbIn()) return false;
		return map1.isEqual(map2) != 0;
	}
	
//	@Override
//	public AffineMapping inverseInContext(PolyhedralDomain context, EList<String> names) throws PolymodelException {
//		AffineMapping inv = super.inverseInContext(context, names);
//		return ISLDefaultFactory.INSTANCE.affineMapping(ISLFactory.islMap(PolyModelToISLString.toString(inv, NAMING_SCHEME.DIMENSIONS)), inv.getParams(), inv.getIndices());
//	}
	
	@Override
	public AffineMapping toAffineMapping(Matrix matrix, EList<IVariable> params, EList<IVariable> indices) {
		return ISLDefaultFactory.INSTANCE.affineMappingFromMatrix(matrix, params, indices);
	}

} //ISLMapImpl
