/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.isl.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLBasicSet;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDimType;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;
import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;
import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.impl.PolyhedralDomainImpl;
import fr.irisa.cairn.model.polymodel.isl.ISLPWQPolynomial;
import fr.irisa.cairn.model.polymodel.isl.ISLSet;
import fr.irisa.cairn.model.polymodel.isl.IslFactory;
import fr.irisa.cairn.model.polymodel.isl.IslPackage;
import fr.irisa.cairn.model.polymodel.isl.factory.ISLDefaultFactory;
import fr.irisa.cairn.model.polymodel.util.PolyModelToISLString;
import fr.irisa.cairn.model.polymodel.util.PolyModelToISLString.NAMING_SCHEME;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>ISL Set</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.polymodel.isl.impl.ISLSetImpl#getExists <em>Exists</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ISLSetImpl extends PolyhedralDomainImpl implements ISLSet {
	/**
	 * The cached value of the '{@link #getExists() <em>Exists</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExists()
	 * @generated
	 * @ordered
	 */
	protected EList<IVariable> exists;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ISLSetImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IslPackage.Literals.ISL_SET;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IVariable> getExists() {
		if (exists == null) {
			exists = new EObjectResolvingEList<IVariable>(IVariable.class, this, IslPackage.ISL_SET__EXISTS);
		}
		return exists;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public ISLPWQPolynomial card() {
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		ISLPWQPolynomial islpw = IslFactory.eINSTANCE.createISLPWQPolynomial();
		return islpw;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public PolyhedralDomain convexHull() {
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLBasicSet bset = set.convexHull();
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(bset, this);
	}
	
	@Override
	public PolyhedralDomain boundingBox() {
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLBasicSet bset = set.simpleHull(); //TODO this may not be a good one
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(bset, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IslPackage.ISL_SET__EXISTS:
				return getExists();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IslPackage.ISL_SET__EXISTS:
				getExists().clear();
				getExists().addAll((Collection<? extends IVariable>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IslPackage.ISL_SET__EXISTS:
				getExists().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IslPackage.ISL_SET__EXISTS:
				return exists != null && !exists.isEmpty();
		}
		return super.eIsSet(featureID);
	}
//
//	@Override
//	public PolyhedralDomain contextDomain() {
//		// Itself
//		JNIISLSet setA = ISLFactory.islSet(PolyModelToISLString.toString(this));
//		// Outerdomain with additional dimension for this domain
//		JNIISLSet setB = ISLFactory.islSet(PolyModelToISLString.PolyhedralDomainWithExtraIndices(this.getOuterDomain(), this.getIndices()));
//		JNIISLSet setI = JNIISLSet.intersect(setA, setB);
//
//		PolyhedralDomain ret = ISLDefaultFactory.INSTANCE.polyhedralDomain(setI, this, this.outerDomain);
//		return ret;
//	}

	@Override
	public PolyhedralDomain union(PolyhedralDomain d) {
		if (d == null)
			throw new RuntimeException("Union with null domain.");
		if (d.getParams().size() != this.getParams().size())
			throw new RuntimeException("Union : number of parameters do not match");
		if (d.getIndices().size() != this.getIndices().size())
			throw new RuntimeException("Union : number of indices do not match");
		JNIISLSet setA = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLSet setB = ISLFactory.islSet(PolyModelToISLString.toString(d, NAMING_SCHEME.DIMENSIONS));
		JNIISLSet setU = JNIISLSet.union(setA, setB);
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(setU, this);
	}

	@Override
	public PolyhedralDomain intersection(PolyhedralDomain d) {
		if (d == null)
			throw new RuntimeException("Intersecting with null domain.");
		if (d.getIndices().size() != this.getIndices().size())
			throw new RuntimeException("Intersection : number of indices do not match");
		String setA_string = PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS);
		String setB_string = PolyModelToISLString.toString(d, NAMING_SCHEME.DIMENSIONS);
		JNIISLSet setA = ISLFactory.islSet(setA_string);		
		JNIISLSet setB = ISLFactory.islSet(setB_string);
		JNIISLSet setI = JNIISLSet.intersect(setA, setB);
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(setI, this);
	}

	@Override
	public boolean isEmpty() {
		JNIISLSet set;
		String string = PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS);
		set = ISLFactory.islSet(string);
		return set.isEmpty() != 0;
	}

	@Override
	public PolyhedralDomain difference(PolyhedralDomain d) {
		if (d == null)
			throw new RuntimeException("Intersecting with null domain.");
		if (d.getIndices().size() != this.getIndices().size())
			throw new RuntimeException("Intersection : number of indices do not match");
		JNIISLSet setA = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLSet setB = ISLFactory.islSet(PolyModelToISLString.toString(d, NAMING_SCHEME.DIMENSIONS));
		JNIISLSet setD = JNIISLSet.substract(setA, setB);
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(setD, this);
	}

	/*
	 * type : type of variables to remove
	 * Only parameters (JNIISLDimType.isl_dim_param) and indices (JNIISLDimType.isl_dim_set)
	 * first : First variable to remove
	 * n : #variables to remove 
	 */
	@Override
	public PolyhedralDomain projection(JNIISLDimType type, int first, int n) {		
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		set.projectOut(type, first, n);
		PolyhedralDomain d = ISLDefaultFactory.INSTANCE.domain();
		List<IVariable> params = new ArrayList<IVariable>(getParams());
		List<IVariable> indices = new ArrayList<IVariable>(getIndices());
		List<IVariable> toBeRemoved = new ArrayList<IVariable>();
		if (type.equals(JNIISLDimType.isl_dim_param)) {			
			for (int i = first; i < first+n; i++) {
				toBeRemoved.add(params.get(i));
			}
			params.removeAll(toBeRemoved);
		}
		else if (type.equals(JNIISLDimType.isl_dim_set)) {
			for (int i = first; i < first+n; i++) {
				toBeRemoved.add(indices.get(i));
			}
			indices.removeAll(toBeRemoved);
		}
		else {
			throw new RuntimeException("Method projection only available for parameters and indices");
		}
		d.getParams().addAll(params);
		d.getIndices().addAll(indices);
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(set, d);
	}
		
	@Override
	public PolyhedralDomain eliminateDims(int first, int n) {
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		set.eliminateDims(first, n);	
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(set, this);
	}

	@Override
	public boolean equivalence(PolyhedralDomain d) {
		JNIISLSet setA = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLSet setB = ISLFactory.islSet(PolyModelToISLString.toString(d, NAMING_SCHEME.DIMENSIONS));
		return setA.isEqual(setB) != 0;
	}

	@Override
	public PolyhedralDomain image(AffineMapping T) {
		JNIISLSet setA = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLMap map = ISLFactory.islMap(PolyModelToISLString.toString(T, NAMING_SCHEME.DIMENSIONS));
		JNIISLSet set = setA.apply(map);
		set = set.removeDivs(); //Remove existential quantifiers
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(set, this);
	}

	@Override
	public PolyhedralDomain preimage(AffineMapping T) {
		if (this.getIndices().size() != T.getFunctions().size()) {
			throw new RuntimeException("Numbe of indicies do not match.");
		}
		JNIISLSet setA = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLMap map = ISLFactory.islMap(PolyModelToISLString.toString(T, NAMING_SCHEME.DIMENSIONS));
		JNIISLSet set = setA.apply(map.reverse());
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(set, T.getParams(), T.getIndices());
	}
	
	@Override
	public void simplify() {
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		set.coalesce();
		getPolyhedra().clear();
		List<IntLinearConstraintSystem> pols = ISLDefaultFactory.INSTANCE.polyhedralDomain(set, this).getPolyhedra();
		getPolyhedra().addAll(pols);
		super.simplify();
		if (getPolyhedra().isEmpty()) getPolyhedra().add(IntegerExpressionUserFactory.linConstraintSystem());
	}
	
	/*
	 * TODO : Add verification to be sure that the set is non-parameterized
	 */
	@Override
	public int nonParameterizedCard() {
		throw new UnsupportedOperationException();
		//Barvinok temporary disabled (Tomofumi)
//		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this));
//		JNIISLPWQPolynomial pwPol = new JNIISLPWQPolynomial(set.copy());
//		if (pwPol.toString().equals("{ infty }")) {
//			throw new RuntimeException("Card of " + set + " = infinity");
//		}
//		String card = pwPol.toString().replaceAll("\\D", "");
//		if (card.equals("")) {			
//			return 0;
//		}
//		return Integer.parseInt(card);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public PolyhedralDomain simplify(PolyhedralDomain context) {
		JNIISLSet setA = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		JNIISLSet setB = ISLFactory.islSet(PolyModelToISLString.toString(context, NAMING_SCHEME.DIMENSIONS));
		
		if (setA.getNDim() < setB.getNDim()) {
			throw new RuntimeException("Cannot simplify with context with larger dimension.");
		}
		
		setB.extend(setA.getNParam(), setA.getNDim());
		JNIISLSet setS = setA.gist(setB);	
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(setS, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public PolyhedralDomain lexMax() {
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(set.lexMax(), this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public PolyhedralDomain lexMin() {
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(set.lexMin(), this);
	}
	
	@Override
	public PolyhedralDomain complement() {
		JNIISLSet set = ISLFactory.islSet(PolyModelToISLString.toString(this, NAMING_SCHEME.DIMENSIONS));
		
		return ISLDefaultFactory.INSTANCE.polyhedralDomain(set.complement(), this);
	}
} // ISLSetImpl
