/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.isl.util;

import fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer;

import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.AffineMappingWithScope;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.PolyhedralDomainWithScope;

import fr.irisa.cairn.model.polymodel.isl.*;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see fr.irisa.cairn.model.polymodel.isl.IslPackage
 * @generated
 */
public class IslSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static IslPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IslSwitch() {
		if (modelPackage == null) {
			modelPackage = IslPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case IslPackage.ISL_SET: {
				ISLSet islSet = (ISLSet)theEObject;
				T result = caseISLSet(islSet);
				if (result == null) result = casePolyhedralDomain(islSet);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IslPackage.ISL_SET_WITH_SCOPE: {
				ISLSetWithScope islSetWithScope = (ISLSetWithScope)theEObject;
				T result = caseISLSetWithScope(islSetWithScope);
				if (result == null) result = caseISLSet(islSetWithScope);
				if (result == null) result = casePolyhedralDomainWithScope(islSetWithScope);
				if (result == null) result = casePolyhedralDomain(islSetWithScope);
				if (result == null) result = caseScopeContainer(islSetWithScope);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IslPackage.ISL_MAP: {
				ISLMap islMap = (ISLMap)theEObject;
				T result = caseISLMap(islMap);
				if (result == null) result = caseAffineMapping(islMap);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IslPackage.ISL_MAP_WITH_SCOPE: {
				ISLMapWithScope islMapWithScope = (ISLMapWithScope)theEObject;
				T result = caseISLMapWithScope(islMapWithScope);
				if (result == null) result = caseISLMap(islMapWithScope);
				if (result == null) result = caseAffineMappingWithScope(islMapWithScope);
				if (result == null) result = caseAffineMapping(islMapWithScope);
				if (result == null) result = caseScopeContainer(islMapWithScope);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IslPackage.ISLPWQ_POLYNOMIAL: {
				ISLPWQPolynomial islpwqPolynomial = (ISLPWQPolynomial)theEObject;
				T result = caseISLPWQPolynomial(islpwqPolynomial);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IslPackage.ISLQ_POLYNOMIAL: {
				ISLQPolynomial islqPolynomial = (ISLQPolynomial)theEObject;
				T result = caseISLQPolynomial(islqPolynomial);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IslPackage.ISL_TERM: {
				ISLTerm islTerm = (ISLTerm)theEObject;
				T result = caseISLTerm(islTerm);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ISL Set</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ISL Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseISLSet(ISLSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ISL Set With Scope</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ISL Set With Scope</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseISLSetWithScope(ISLSetWithScope object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ISL Map</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ISL Map</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseISLMap(ISLMap object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ISL Map With Scope</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ISL Map With Scope</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseISLMapWithScope(ISLMapWithScope object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ISLPWQ Polynomial</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ISLPWQ Polynomial</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseISLPWQPolynomial(ISLPWQPolynomial object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ISLQ Polynomial</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ISLQ Polynomial</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseISLQPolynomial(ISLQPolynomial object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ISL Term</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ISL Term</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseISLTerm(ISLTerm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Polyhedral Domain</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Polyhedral Domain</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePolyhedralDomain(PolyhedralDomain object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Scope Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Scope Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseScopeContainer(ScopeContainer object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Polyhedral Domain With Scope</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Polyhedral Domain With Scope</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePolyhedralDomainWithScope(PolyhedralDomainWithScope object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Affine Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Affine Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAffineMapping(AffineMapping object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Affine Mapping With Scope</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Affine Mapping With Scope</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAffineMappingWithScope(AffineMappingWithScope object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //IslSwitch
