package fr.irisa.cairn.model.polymodel.tests;

import junit.framework.TestCase;

import org.junit.Test;

import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.isl.factory.ISLDefaultFactory;

public class ISLStringParseTest extends TestCase {

	@Test
	public void testDomain1() {
		String input = "[] -> { [i] : 0<=i<10 } ";
		String expected = "{i|i>= 0 && -i+9>= 0}";
		
		parseDomain(input, expected);
	}
	
	@Test
	public void testDomain2() {
		String input = "[N] -> { [i] : 0<=i<N } ";
		String expected = "{N,i|i>= 0 && N-i-1>= 0}";
		
		parseDomain(input, expected);
	}

	@Test
	public void testDomain3() {
		String input = "[P,Q,R] -> { [i,j,k] : 0<=i<P & i<=j<Q & j<=k<R} ";
		String expected = "{P,Q,R,i,j,k|i>= 0 && P-i-1>= 0 && -i+j>= 0 && Q-j-1>= 0 && -j+k>= 0 && R-k-1>= 0}";
		
		parseDomain(input, expected);
	}

	@Test
	public void testMapping1() {
		String input = "[] -> { [i] -> [i] } ";
		String expected = "(i->i)";
		
		parseMapping(input, expected);
	}
	
	@Test
	public void testMapping2() {
		String input = "[N] -> { [i] -> [i] } ";
		String expected = "(N,i->i)";
		
		parseMapping(input, expected);
	}

	@Test
	public void testMapping3() {
		String input = "[N] -> { [i] -> [] } ";
		String expected = "(N,i->)";
		
		parseMapping(input, expected);
	}

	@Test
	public void testMapping4() {
		String input = "[N] -> { [i] -> [N+i-2] } ";
		String expected = "(N,i->i+N-2)";
		
		parseMapping(input, expected);
	}

	@Test
	public void testMapping5() {
		String input = "[N] -> { [i] -> [i,0,i] } ";
		String expected = "(N,i->i,0,i)";
		
		parseMapping(input, expected);
	}
	
	@Test
	public void testMapping6() {
		String input = "[N] -> { [i,j] -> [i+j,j-i] } ";
		String expected = "(N,i,j->i+j,-i+j)";
		
		parseMapping(input, expected);
	}
	
	private void parseDomain(String input, String expected) {
		PolyhedralDomain domain = ISLDefaultFactory.INSTANCE.polyhedralDomainFromISLString(input);		
		
		System.out.println("=============================");
		System.out.println(domain);
		System.out.println(expected);
		System.out.println();
		assertEquals(expected, domain.toString());
	}
	
	private void parseMapping(String input, String expected) {
		AffineMapping mapping = ISLDefaultFactory.INSTANCE.affineMappingFromISLString(input);		
		
		System.out.println("=============================");
		System.out.println(mapping);
		System.out.println(expected);
		System.out.println();
		assertEquals(expected, mapping.toString());
	}
}
