package fr.irisa.cairn.model.polymodel.tests;

import java.util.Arrays;
import java.util.List;

import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLSet;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraFactory;
import fr.irisa.cairn.model.integerLinearAlgebra.SymbolVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntExpressionParser;
import static fr.irisa.cairn.jnimap.isl.jni.ISLFactory.islSet;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.var;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.isl.factory.ISLDefaultFactory;
import fr.irisa.cairn.model.polymodel.util.PolyModelToISLString;
import fr.irisa.cairn.model.polymodel.util.PolyModelToISLString.NAMING_SCHEME;

public class UnionTest {

	public static void main(String[] args) {

		/*
		 *Testing the polylib format parser when calling ISL from polymodel representation 
		 */
		List<String> params = Arrays.asList( new String[]{"N"});
		List<String> ids = Arrays.asList( new String[]{"i", "j"});
		List<String> constraints = Arrays.asList( new String[]{"N>0", "0<=i", "i<N", "0<=j", "j<N"});
		PolyhedralDomain dom = ISLDefaultFactory.INSTANCE.polyhedralDomainFromString(params, ids, constraints);
		String string = PolyModelToISLString.toString(dom, NAMING_SCHEME.DIMENSIONS);
		JNIISLSet setA1 = ISLFactory.islSet(string);
		PolyhedralDomain dom2 = ISLDefaultFactory.INSTANCE.polyhedralDomain(setA1, dom);
		System.out.println(dom);
		System.out.println(dom2);
		System.out.println(dom.equivalence(dom2));
		
		/*
		 * En utilisant les ISLSetImpl (polymodel.isl) et en passant par la ISLDefaultFactory dans l'appel à union
		 */
		IntExpressionParser parser = new IntExpressionParser();
		
		SymbolVariable var_i = var("i");
		
		PolyhedralDomain d1 = ISLDefaultFactory.INSTANCE.domain();
		d1.getIndices().add(var_i);
		IntLinearConstraintSystem p1 = IntegerLinearAlgebraFactory.eINSTANCE.createIntLinearConstraintSystem();
		p1.getConstraints().add(parser.parseIntLinearConstraint("i >= 0", var_i));
		p1.getConstraints().add(parser.parseIntLinearConstraint("i - 5 < 0", var_i));
		d1.getPolyhedra().add(p1);
		
		PolyhedralDomain d2 = ISLDefaultFactory.INSTANCE.domain();
		d2.getIndices().add(var_i);
		IntLinearConstraintSystem p2 = IntegerLinearAlgebraFactory.eINSTANCE.createIntLinearConstraintSystem();
		p2.getConstraints().add(parser.parseIntLinearConstraint("i >= 6", var_i));
		p2.getConstraints().add(parser.parseIntLinearConstraint("i - 12 < 0", var_i));
		d2.getPolyhedra().add(p2);
		
		PolyhedralDomain dU = d1.union(d2);
		
		System.out.println("Version ISLSetImpl");
		System.out.println("Union : " + dU + ", Vide : " + dU.isEmpty());
		
		/*
		 * En utilisant les JNIISLSet (jnimap.isl)
		 */
		JNIISLSet set1 = islSet("{ [i] : i>=0 & i<5 }");
		JNIISLSet set2 = islSet("{ [i] : i>=6 & i<12 }");
		JNIISLSet setU = JNIISLSet.union(set1, set2);
		
		System.out.println("Version JNIISLSet");
		System.out.println("Union : " + setU + ", Vide : " + (setU.isEmpty() != 0));
		
		/*
		 * Polyhedral Hull
		 */
		JNIISLSet setA = islSet("[N] -> { [i0] : exists (e0 = [(i0)/2]: 2e0 = i0 and N >= 1 and i0 >= 0 and 2i0 <= -1 + N) }");
		System.out.println("Domain with E : " + setA);
		System.out.println("Polyhedral Hull : " + setA.polyhedralHull());
	}
	
}
