package org.polymodel.verifier.IF.ada;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.polymodel.verifier.DIM_TYPE;
import org.polymodel.verifier.MemoryMap;
import org.polymodel.verifier.factory.VerifierUserFactory;

import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.ada.ADAInput;
import fr.irisa.cairn.model.polymodel.ada.CandidateStatement;
import fr.irisa.cairn.model.polymodel.prdg.PRDG;
import fr.irisa.cairn.model.polymodel.prdg.PRDGNode;

public class VerifierInput {

	public PRDG prdg;
	public Map<PRDGNode, AffineMapping> schedules;
	public Map<PRDGNode, List<DIM_TYPE>> dimTypes;
	public Map<PRDGNode, MemoryMap> memoryMaps;
	
	public VerifierInput(PRDG prdg, Map<PRDGNode, AffineMapping> schedules, Map<PRDGNode, List<DIM_TYPE>> dimTypes, Map<PRDGNode, MemoryMap> memoryMaps) {
		this.prdg = prdg;
		this.schedules = Collections.unmodifiableMap(schedules);
		this.dimTypes = Collections.unmodifiableMap(dimTypes);
		this.memoryMaps = Collections.unmodifiableMap(memoryMaps);
	}
	
	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer("VerifierInput:\n");
		sb.append("PRDGNodes:"+prdg.getNodes()+"\n");
		sb.append("PRDGEdges:"+prdg.getEdges()+"\n");
		sb.append("Schedules:\n");
		for (PRDGNode node : prdg.getNodes()) {
			sb.append(schedules.get(node) + "\n");
		}
		sb.append("DimTypes:\n");
		for (PRDGNode node : prdg.getNodes()) {
			sb.append(dimTypes.get(node) + "\n");
		}
		sb.append("MemoryMaps:\n");
		for (PRDGNode node : prdg.getNodes()) {
			sb.append(memoryMaps.get(node) + "\n");
		}
		
		return sb.toString();
	}
	
	public static VerifierInput build(ADAInput adaInput, Map<CandidateStatement, List<DIM_TYPE>>  dimTypes) {
		PRDG prdg = adaInput.generatePRDG();
		
		Map<PRDGNode, AffineMapping> spaceTimeMaps = new HashMap<PRDGNode, AffineMapping>();
		Map<PRDGNode, MemoryMap> memoryMaps = new HashMap<PRDGNode, MemoryMap>();
		
		//SpaceTimeMaps are schedules given for ADAInput
		//MemoryMap are access functions to the WriteAccess in ADAInput
		for (PRDGNode node : prdg.getNodes()) {
			CandidateStatement stmt = adaInput.getStatement(node.getName());
			spaceTimeMaps.put(node, stmt.getSchedule());
			memoryMaps.put(node, VerifierUserFactory.createMemoryMap(stmt.getWrite().getVariable(), stmt.getWrite().getAccessFunction()));
		}
		//Dimension types must be specified separately, and it is converted to similar structure using PRDGNodes
		Map<PRDGNode, List<DIM_TYPE>> dimTypesForNode = new HashMap<PRDGNode, List<DIM_TYPE>>();
		for (PRDGNode node : prdg.getNodes()) {
			dimTypesForNode.put(node, dimTypes.get(adaInput.getStatement(node.getName())));
		}
		
		return new VerifierInput(prdg, spaceTimeMaps, dimTypesForNode, memoryMaps);
	}
}
