/*************************
  heap.h:  see heap.cpp
 ************************/
#include <math.h>

// Objects to represent the nodes of the position heap's tree.
class downNode;  
class mylist;
const int root = 0;
const int NOCHILD = -1;  
class heap
{
    public:
        heap (char *str);
        ~heap();
        void preorderPrint();
        mylist *search(char *pattern, int patternLength);
    private:
        int *parent;          // upwardly-directed tree for storing primal 
                              //   position heap during construction
                              //   (set to NULL once constructed)
	char *text;           // text string that the heap is constructed from
	int textLength;       // number of characters in the text
        int index(char *pattern, int patternLength);
        int getTextLength();
        void build();
        void appendSubtreeOccurrences(int node, mylist *Occurrences);
        mylist *pathOccurrences(char *pattern, int patternLength, int &lastNode);
        bool isOccurrence(char *pattern, int patLength, int pos);
	downNode *downArray; 
        int childOnLetter(int node, int depth, char c);  
        void insertChild (int child, int parent); 
        void preorderPrint (int index, int depth);
};
