/***************************
 * node.cpp:  implements a node in a downwardly-directed rooted tree, that is,
 * a tree where each node has a list of its children, and where each node
 * can be labeled with a discovery and finishing time during a depth-first
 * search, as well as a "maximal reach pointer" to a descendant node.
 * See heap.cpp for more details.
 * **************************/
#include <iostream>
#include "node.h"
using std::cout;

node::node()
{
   child = -1;
   sibling = -1;
   discoveryTime = -1;
   finishingTime = -1;
   maxReach = -1;
}

int node::getChild ()
{
   return child;
}

int node::getSibling ()
{
   return sibling;
}

int node::getDiscoveryTime()
{
   return discoveryTime;
}

int node::getFinishingTime()
{
   return finishingTime;
}

int node::getMaxReach()
{
   return maxReach;
}

void node::setChild (int c)
{
   child = c;
}

void node::setSibling (int s)
{
   sibling = s;
}

void node::setDiscoveryTime(int i)
{
   discoveryTime = i;
}

void node::setFinishingTime(int i)
{
   finishingTime = i;
}

void node::setMaxReach(int m)
{
   maxReach = m;
}

