#!/usr/bin/python
import re
import os
import commands


print "extracting system"
new_dir = "tempdir/"
old_dir = " ../src/gui/"
str_table_filename = "../conf/gui-string-table-en.txt"
files = commands.getoutput('''find ''' + old_dir + ''' -maxdepth 1 -iname \*\.[c\|h]pp''').split()

os.system("rm "+new_dir+"/*")
string_pattern = re.compile('".+?"')
cancelled = False
str_table = {}

# ----------------------------------------
# read current string table
str_table_file = open(str_table_filename).read().split("\n")
for str in str_table_file:

    line = str.split("=");
    if len(line) < 2:
        continue

    key = line[0]
    val = line[1]
    str_table[key] = val

# ----------------------------------------


for filename in files:
    file = open(filename)
    old_filename = filename;
    filename = filename.split("/");
    filename = filename[len(filename)-1]
    new_filename = new_dir+"/"+filename
    new_file = open(new_filename,"w")
    lines = file.read().split("\n");

    for line in lines:
        m = string_pattern.findall(line)
        # only do it if line isn't a print statement
        # and matches the pattern
        if(string_pattern.search(line) != None
           and re.search("include",line) == None
           and re.search("g_signal_connect",line) == None
           and re.search("cout",line) == None
           and re.search("getString",line) == None
           and re.search("cerr",line) == None):
            # loop through each string
            for str in m:
                if len(str) > 4:
                    print "\n\n"
                    for s in str_table:
                        print s
                    print "\n\n"
                    print "IN:\t"+filename
                    print "LINE:\t"+line
                    print "STRING:\t"+str
                    print "\n"

                    # read in name for this string
                    if not cancelled:
                        cont = True
                        while cont:
                            cont = False
                            strname = raw_input("NAME:")
                            # check if string is already in table
                            if strname in str_table:
                                if not str == str_table[strname]:
                                    print "That name used already for a different string!"
                                    cont = True;
                                else:
                                    print "Using string name " + strname + " again."
                        # now update the line and string table
                        if(len(strname) > 2):
                            line = line.replace(str, "view->getString(\""+strname+"\")")
                            str_table[strname] = str
                            print line
                        elif strname == "q":
                            cancelled = True;
        # output line to the new file
        new_file.write(line+"\n")

    # close the file
    new_file.close()
    # copy new file to old
    if cancelled:
        break

# write string table to file
table_file = open(str_table_filename,"w")
keys = str_table.keys()
keys.sort()
for s in keys:
    table_file.write(s+"="+str_table[s]+"\n")
    
