/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * CEBLView.hpp
 * \author Jeshua Bratman
 *
 * Interface for a CEBL View
 */

#ifndef CEBLVIEW_H
#define CEBLVIEW_H

#include "CEBLIncludes.hpp"

class CEBLModel;

class CEBLView
{
protected:
  CEBLModel * model;

public:
 CEBLView(CEBLModel * model) {this->model = model;}
  virtual ~CEBLView() {}

  //! start the View
  virtual void Start() {};

  //! get a pointer to the model
  CEBLModel * getModel() { return model; }

};

#endif
