/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * Exceptions.hpp
 * \author Jeshua Bratman
 *
 * Various exceptions used with CEBL
 */


#ifndef EXCEPTIONS_H
#define EXCEPTIONS_H

#include <exception>
#include <string>
using std::string;

//! Exception thrown when a file manipulation fails
class FileException : public std::exception
{
private:

  string message;

public:
  FileException(string message)
  {
    this->message = message;
  }

  virtual ~FileException() throw(){};

  virtual const char * what() const throw()
  {
    return string("FileException: "+message).c_str();
  }
};
//! Exception thrown when a matrix modification fails
class MatrixException : public std::exception
{
private:

  string message;

public:
  MatrixException(string message)
  {
    this->message = message;
  }

  virtual ~MatrixException() throw(){};

  virtual const char * what() const throw()
  {
    return string("MatrixException: "+message).c_str();
  }
};

//! Data Exception
class DataException : public std::exception
{
protected:
  string message;

public:
  DataException(string message)
  {
    this->message = message;
  }

  virtual ~DataException() throw() {};

  virtual const char * what() const throw()
  {
    return string("DataException: " + message).c_str();
  }
};

class DataExceptionUnderflow : public DataException
{
public:
  DataExceptionUnderflow(string message) : DataException(message)
  {}
  virtual ~DataExceptionUnderflow() throw() {};

  virtual const char * what() const throw()
  {
    return string("DataExceptionUnderflow: " + message).c_str();
  }
};



//! Device Exception
class DeviceException : public std::exception
{
protected:
  string message;

public:
  DeviceException(string message)
  {
    this->message = message;
  }

  virtual ~DeviceException() throw() {};

  virtual const char * what() const throw()
  {
    return string("DeviceException: " + message).c_str();
  }
};

//! DataSource Exception
class DataSourceException : public std::exception
{
protected:
  string message;

public:
  DataSourceException(string message)
  {
    this->message = message;
  }

  virtual ~DataSourceException() throw() {};

  virtual const char * what() const throw()
  {
    return string("DataSourceException: " + message).c_str();
  }
};

//! DataProcess Exception
class DataProcessException : public std::exception
{
protected:
  string message;

public:
  DataProcessException(string message)
  {
    this->message = message;
  }

  virtual ~DataProcessException() throw() {};

  virtual const char * what() const throw()
  {
    return string("DataProcessException: " + message).c_str();
  }
};

//! Plugin Exception
class PluginException : public std::exception
{
protected:
  string message;

public:
  PluginException(string message)
  {
    this->message = message;
  }

  virtual ~PluginException() throw() {};

  virtual const char * what() const throw()
  {
    return string("PluginException: " + message).c_str();
  }
};


//! Training Exception
class TrainingException : public std::exception
{
protected:
  string message;

public:
  TrainingException(string message)
  {
    this->message = message;
  }

  virtual ~TrainingException() throw() {};

  virtual const char * what() const throw()
  {
    return string("TrainingException: " + message).c_str();
  }
};

//! Classification Exception
class ClassificationException : public std::exception
{
protected:
  string message;

public:
  ClassificationException(string message)
  {
    this->message = message;
  }

  virtual ~ClassificationException() throw() {};

  virtual const char * what() const throw()
  {
    return string("ClassificationException: " + message).c_str();
  }
};


//! Feature Exception
class FeatureException : public std::exception
{
protected:
  string message;

public:
  FeatureException(string message)
  {
    this->message = message;
  }

  virtual ~FeatureException() throw() {};

  virtual const char * what() const throw()
  {
    return string("FeatureException: " + message).c_str();
  }
};


//! Inturrupt Exception
class InturruptException : public std::exception
{
protected:
  string message;

public:
  InturruptException(string message)
  {
    this->message = message;
  }

  virtual ~InturruptException() throw() {};

  virtual const char * what() const throw()
  {
    return string("InturruptException: " + message).c_str();
  }
};



//! StringTable Exception
class StringTableException : public std::exception
{
protected:
  string message;

public:
  StringTableException(string message)
  {
    this->message = message;
  }

  virtual ~StringTableException() throw() {};

  virtual const char * what() const throw()
  {
    return string("StringTableException: " + message).c_str();
  }
};

#endif
