/*
 * CEBL : CSU EEG Brain-Computer Interface Lab
 *
 * Author: Jeshua Bratman - jeshuabratman@gmail.com
 *
 * This file is part of CEBL.
 *
 * CEBL is free software; you can redistribute it and/or modify it.
 * We only ask that if you use our code that you cite the source in
 * your project or publication.
 *
 * EEG Group (www.cs.colostate.edu/eeg)
 * Department of Computer Science
 * Colorado State University
 * 
 */

/*!
 * Param.hpp
 * \author Jeshua Bratman
 */

#ifndef PARAM_H
#define PARAM_H
#include <string>
#include <values.h>
using std::string;

namespace CEBL
{

  enum ParamID
    {
      PARAM_BOOLEAN,
      PARAM_INTEGER,
      PARAM_DOUBLE,
      PARAM_STRING
    };

  union ParamDataUnion
  {
    double d;
    int i;
    bool b;
  };

  //Paramater type
  class Param
  {
  private:
    ParamID id;
    ParamDataUnion data;
    ParamDataUnion max;
    ParamDataUnion min;
    ParamDataUnion step;
    string s;

  public:

    std::string name;
    std::string description;

    //constructors for different data types
    Param()
    {
      
    }

    Param(std::string name, std::string description, double value)
    {
      this->name = name;
      this->description = description;
      data.d = value;
      min.d = -MAXDOUBLE;
      max.d = MAXDOUBLE;
      step.d = .5;
      id = PARAM_DOUBLE;
    }

    Param(std::string name, std::string description, string value)
    {
      this->name = name;
      this->description = description;
      s = value;
      id = PARAM_STRING;
    }

    Param(std::string name, std::string description, int value)
    {
      this->name = name;
      this->description = description;
      data.i = value;
      min.i = -MAXINT;
      max.i = MAXINT;
      step.i = 1;
      id = PARAM_INTEGER;
    }

    Param(std::string name, std::string description, bool value)
    {
      this->name = name;
      this->description = description;
      data.b = value;
      id = PARAM_BOOLEAN;
    }

    Param(std::string name, std::string description, ParamID value)
    {
      this->name = name;
      this->description = description;
      id = value;
    }

    Param(const Param &p)
    {
      this->name = p.name;
      this->description = p.description;
      this->id = p.id;
      this->data = p.data;
      this->s = p.s;
      this->max = p.max;
      this->min = p.min;
      this->step = p.step;
    }

    void setDouble(double value)
    {
      data.d = value;
    }

    void setInt(int value)
    {
      data.i = value;
    }

    void setBool(bool value)
    {
      data.b = value;
    }

    void setString(string value)
    {
      s = value;
    }

    double getDouble() const
    {
      return data.d;
    }

    int getInt() const
    {
      return data.i;
    }

    bool getBool() const
    {
      return data.b;
    }

    string getString() const
    {
      return s;
    }


    //check what type of data this is
    bool operator==(ParamID id)
    {
      return id==this->id;
    }

    void setMax(double max)
    {
      this->max.d = max;
    }

    void setMin(double min)
    {
      this->min.d = min;
    }

    void setStep(double step)
    {
      this->step.d = step;
    }

    void setMax(int max)
    {
      this->max.i = max;
    }

    void setMin(int min)
    {
      this->min.i = min;
    }

    void setStep(int step)
    {
      this->step.i = step;
    }

    //return max and min
    double getMax() const
    {
      switch(id)
        {
        case PARAM_DOUBLE:
          return max.d;
        default:
          return this->max.i;
        }
    }

    double getMin() const
    {
      switch(id)
        {
        case PARAM_DOUBLE:
          return min.d;
        default:
          return min.i;
        }
    }

    double getStep() const
    {
      switch(id)
        {
        case PARAM_DOUBLE:
          return step.d;
        default:
          return step.i;
        }
    }
  };
}
#endif
