/*!
 * CEBLViewCLI.cpp
 * \author Jeshua Bratman
 *
 * GTK View for CEBL
 */


#include "CEBLViewCLI.hpp"
#include <boost/program_options.hpp>
//namespaces
namespace po = boost::program_options;


//----------------------------------------------------------------------
// Constructors / Destructors

CEBLViewCLI::CEBLViewCLI(CEBLModel *model, int ac, char ** av) : CEBLView(model)
{
  this->ac = ac;
  this->av = av;

}


CEBLViewCLI::~CEBLViewCLI()
{

}


//----------------------------------------------------------------------
// Start the view

void CEBLViewCLI::Start()
{

  //arguments
  string session_file = "";


  try
    {
      //create arguments
      po::options_description cmdline_options("CEBL Options");
      cmdline_options.add_options()
        ("help", "Print Help")
        ("version", "Print Version String")
        ("session-file,f", po::value<string>(), "Specify Session File")
        ;

      // process actual argv
      po::variables_map vm;
      po::store(po::command_line_parser(ac, av).
        	options(cmdline_options).run(), vm);
      po::notify(vm);

      // go through each option and do something
      if (vm.count("help"))
        {
          cout << cmdline_options << "\n";
          return;
        }
      if (vm.count("version"))
        {
          cout << PACKAGE_STRING << endl;
          return;
        }
      if (vm.count("session-file"))
        {
          session_file = vm["session-file"].as< string >();
          cout << "Loading from session file <" << session_file << ">\n";
        }

    }
  catch(exception& e)
    {
      cerr << "Error parsing command line arguments: " << e.what() << "\n";
      return;
    }
  catch(...)
    {
      cerr << "Error parsing command line arguments.\n";
      return;
    }


  //----------------------------------------------------------------------

  cout << "* Searching for mindset...\n";
  if(model->deviceExists())
    {
      cout << "Found mindset at " << model->deviceGetLocation() << "\n";
    }
  else
    {
      cout << model->deviceGetError() << "\n";
    }




}



