/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * CEBLViewCLI.cpp
 * \author Jeshua Bratman
 *
 * Command Line View for CEBL
 */


#ifndef CEBLVIEWCLI_H
#define CEBLVIEWCLI_H

// STANDARD INCLUDES
//for NULL
#include <cstdlib>
//std headers
#include <vector>



// CEBL INCLUDES
#include "../CEBLView.hpp"
#include "../CEBLModel.hpp"



class CEBLViewCLI : public CEBLView
{
private:
  int ac;
  char ** av;

public:
  CEBLViewCLI(CEBLModel* model, int ac = 0, char ** av = NULL);
  ~CEBLViewCLI();

  //! start the View
  void Start();

};



#endif
