/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/




/**************************************************
 *         cppR.hpp
 * Author: Jeshua Bratman
 * Description: Contains various R-like functions
 *   to work with uBlas matrices and vectors.
 *
 * Note: Functions are located in 5
 *       separate header files included at the end
 *
 **************************************************/


#ifndef CPPR_H //keep this header file from being included more than once
#define CPPR_H

//exception handling for cppR
#include "cppR_exceptions.hpp"

//definitions of manipulation and slicing functions
#include "cppR_manipulation.hpp"

//definition of simple math and statistics functions
#include "cppR_stats.hpp"

//definition of matrix and vector math functions
#include "cppR_math.hpp"

//definition of matrix and vector operators
#include "cppR_operators.hpp"

//definition of utility functions
#include "cppR_utils.hpp"

//definition of construction and conversion functions
#include "cppR_construction.hpp"


//--------------------------------------------------

#endif
