/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/


#ifndef CPPREXCEPTIONS_H
#define CPPREXCEPTIONS_H
#include <exception>
#include <string>
using std::string;




class cppRException : public std::exception
{
private:
  string message;

public:
  cppRException(string message)
  {
    this->message = message;
  }

  virtual ~cppRException() throw(){};

  virtual const char * what() const throw()
  {
    return string("cppRException: "+message).c_str();
  }
};


/*! Checks if specified condition is true or not, and if not, throws a
  cppRExeption with the specified message.
  \param condition condition to check
  \param message message to throw
*/
inline void cppR_assert(bool condition, const char * message)
{
  if(!condition)
    throw(cppRException(message));
}



#endif
