/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/


//--------------------------------------------------
//   cppR_operators.hpp
// Matrix and Vector operators


#ifndef CPPR_OPERATORS_H //make sure this only gets included once
#define CPPR_OPERATORS_H

//--------------------------------------------------
namespace cppR
{
  //==============================
  //operator/
  template < typename T >
  ublas::matrix<T> operator/(const T &value, ublas::matrix<T> &m1)
  {
    ublas::matrix<T> ret(m1.size1(), m1.size2());
    for(unsigned int row=0;row<m1.size1();row++)
      {
        for(unsigned int col=0;col<m1.size2();col++)
          {
            ret(row,col) = value / m1(row,col);
          }
      }
    return ret;
  }

  //==============================
  //operator/
  template < typename T >
  ublas::vector<T> operator/(const T &value, ublas::vector<T> &v1)
  {
    ublas::vector<T> ret(v1.size());
    for(unsigned int row=0;row<v1.size();row++)
      {
        ret[row] = value / v1[row];
      }
    return ret;
  }

}//end of namespace


//--------------------------------------------------



#endif
