/* CEBLGtkWidget.hpp
 * \author Jeshua Bratman
 *
 * Simple C++ gtk widget class.
 *
 */

#include "CEBLGtkWidget.hpp"

//-----------------------------------------------------------
// Constructors / Destructors

CEBLGtkWidget::CEBLGtkWidget()
{
  cebl_gtk_widget_container = gtk_vbox_new(false, 0);
  g_object_ref(cebl_gtk_widget_container);
}
CEBLGtkWidget::~CEBLGtkWidget()
{
  g_object_unref(cebl_gtk_widget_container);
}

//-----------------------------------------------------------
// Widget Controls

GtkWidget* CEBLGtkWidget::getContainer()
{
  return cebl_gtk_widget_container;
}
CEBLGtkWidget::operator GtkWidget*()
{
  return cebl_gtk_widget_container;
}
// remove a widget from the container
void CEBLGtkWidget::removeWidget(GtkWidget* widget)
{
  gtk_container_remove(GTK_CONTAINER(this->cebl_gtk_widget_container),widget);
}

// hide the widget
void CEBLGtkWidget::hide()
{
  gtk_widget_hide(this->cebl_gtk_widget_container);
}


// show the widget
void CEBLGtkWidget::show()
{
  gtk_widget_show_all(this->cebl_gtk_widget_container);
}

