/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/* CEBLGtkWidget.hpp
 * \author Jeshua Bratman
 *
 * Simple C++ gtk widget class.
 *
 */

#ifndef CEBLGTKWIDGET_H
#define CEBLGTKWIDGET_H

#include <gtk/gtk.h>

class CEBLGtkWidget
{
protected:
  GtkWidget * cebl_gtk_widget_container;
  //add a widget to the container
  void setWidgetContainer(GtkWidget *widget) {
    gtk_box_pack_start(GTK_BOX(cebl_gtk_widget_container),widget,true,true,0);
  }

public:
  CEBLGtkWidget();
  virtual ~CEBLGtkWidget();

  //widget controls

  //! get pointer to gtk widget
  virtual GtkWidget* getContainer();
  //! get pointer to gtk widget
  virtual operator GtkWidget*();
  //! remove a widget from the container
  virtual void removeWidget(GtkWidget* widget);
  //! hide the widget
  virtual void hide();
  //! show the widget
  virtual void show();
};

#endif

