/* CEBLGtkWidgetDetachable.cpp
 * \author Jeshua Bratman
 *
 * Sublclass to CEBLGtkWidget which automatically adds
 * detach button and functionality to create detachable
 * widgets.
 */


#include "CEBLGtkWidgetDetachable.hpp"
#include "WidgetUtils.hpp"

CEBLGtkWidgetDetachable::CEBLGtkWidgetDetachable()
{
  this->is_detached = false;
  this->outer_container = gtk_vbox_new(false, 0);
  this->inner_container = gtk_vbox_new(false, 0);
  //pack parent class' container into the inner container
  gtk_box_pack_start(GTK_BOX(this->inner_container),this->cebl_gtk_widget_container,true,true,0);
  //pack inner container into outer container for now (until it is detached)
  gtk_box_pack_start(GTK_BOX(this->outer_container),this->inner_container,true,true,0);

  //reference widget to keep it alive
  g_object_ref(this->outer_container);
  g_object_ref(this->inner_container);


  //detached toggle
  GtkWidget *box_controls = gtk_hbox_new(false, 0);
  toggle_detached = gtk_check_button_new();

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle_detached),false);
  g_signal_connect(G_OBJECT(toggle_detached),
        	   "toggled",
        	   G_CALLBACK(CB_toggleDetached),
        	   (gpointer) this);

  gtk_box_pack_end(GTK_BOX(box_controls),gtk_label_new(") "),false,false,2);
  gtk_box_pack_end(GTK_BOX(box_controls),toggle_detached,false,false,2);
  gtk_box_pack_end(GTK_BOX(box_controls),gtk_label_new(" Detach ("),false,false,2);
  gtk_box_pack_end(GTK_BOX(inner_container),box_controls,false,false,5);
  gtk_widget_show_all(outer_container);
}

//destructor
CEBLGtkWidgetDetachable::~CEBLGtkWidgetDetachable()
{
  //dereference widgets so they get freed
  g_object_unref(this->outer_container);
  g_object_unref(this->inner_container);
}

void CEBLGtkWidgetDetachable::hide()
{
  if(this->is_detached)
    {
      //      this->CB_toggleDetached(NULL,this);
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(this->toggle_detached),false);
    }
  gtk_widget_hide(this->cebl_gtk_widget_container);
}

//--------------------------------------------------


void CEBLGtkWidgetDetachable::CB_toggleDetached(GtkWidget *w,  gpointer data)
{
  CEBLGtkWidgetDetachable* widget = ((CEBLGtkWidgetDetachable*)data);

  if(!widget->is_detached)
    //OPEN WINDOW
    {
      //open window
      widget->detached_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
      GtkWidget * window = widget->detached_window;
      g_signal_connect(G_OBJECT(window), "delete_event",
              	       G_CALLBACK(CB_windowDelete), widget);
      //set window options
      gtk_window_set_title(GTK_WINDOW(window), "Detached CEBL View");
      gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
      //      gtk_window_set_transient_for(GTK_WINDOW(window),GTK_WINDOW(WidgetUtils::getMainWindow()));
      gtk_window_set_destroy_with_parent(GTK_WINDOW(window), true);
      gtk_window_set_default_size(GTK_WINDOW(window),800,600);


      //remove interface box from main window and put it in this window
      gtk_widget_ref(widget->inner_container);
      gtk_container_remove(GTK_CONTAINER(widget->outer_container),widget->inner_container);
      gtk_container_add(GTK_CONTAINER(window),widget->inner_container);
      gtk_widget_unref(widget->inner_container);

      //SHOW WINDOW
      gtk_widget_show_all(window);

      //set flag
      widget->is_detached = true;
    }
  else
    {
      //remove interface box from window and put it in the main window
      gtk_widget_ref(widget->inner_container);
      gtk_container_remove(GTK_CONTAINER(widget->detached_window),widget->inner_container);
      gtk_container_add(GTK_CONTAINER(widget->outer_container),widget->inner_container);
      gtk_widget_unref(widget->inner_container);

      gtk_widget_destroy(widget->detached_window);
      widget->detached_window=NULL;

      //set flag
      widget->is_detached = false;
    }
}

gboolean CEBLGtkWidgetDetachable::CB_windowDelete(GtkWidget *w, GdkEvent *event, gpointer data)
{
  CEBLGtkWidgetDetachable * widget = ((CEBLGtkWidgetDetachable*)data);
  widget->CB_toggleDetached(w,  data);
  return true;
}


