/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/* CEBLGtkWidgetDetachable.hpp
 * \author Jeshua Bratman
 *
 * Sublclass to CEBLGtkWidget which automatically adds
 * detach button and functionality to create detachable
 * widgets.
 */

#ifndef CEBLGTKWIDGETDETACHABLE_H
#define CEBLGTKWIDGETDETACHABLE_H

#include "CEBLGtkWidget.hpp"

class CEBLGtkWidgetDetachable : public CEBLGtkWidget
{
private:
  static void CB_toggleDetached(GtkWidget *, gpointer);
  static gboolean CB_windowDelete(GtkWidget *widget, GdkEvent *event, gpointer data);

protected:
  bool is_detached;
  GtkWidget * outer_container, *inner_container, *detached_window, *toggle_detached;

public:
  CEBLGtkWidgetDetachable();
  ~CEBLGtkWidgetDetachable();
  GtkWidget* getContainer() { return outer_container; }
  operator GtkWidget*() { return outer_container; }
  bool isDetached() { return is_detached; }
  void hide();
};

#endif

