/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * CEBLViewGTK.cpp
 * \author Jeshua Bratman
 *
 * GTK View for CEBL
 */


#ifndef CEBLVIEWGTK_H
#define CEBLVIEWGTK_H

// STANDARD INCLUDES

//for NULL
#include <cstdlib>
//include gtk headers
#include <gtk/gtk.h>
//std headers
#include <vector>



// CEBL INCLUDES
#include "../CEBLView.hpp"
#include "../CEBLModel.hpp"


// Forward Declarations
class Tab;
class ToolbarMenu;
class DataSourceCombo;
class InterfaceCombo;
class StatusBar;
class StringTable;
class InfoBar;

class CEBLViewGTK : public CEBLView
{
private:
  //args to pass to gtk
  int ac;
  char ** av;

  //widgets
  GtkWidget *main_window,
    *main_container,
    *main_notebook;
  StatusBar *status_bar;
  InfoBar *info_bar;

  ToolbarMenu * main_menu;

  //gui needs its own string table
  StringTable * string_table;

  //tabs
  std::vector<Tab* > tabs;
  DataSourceCombo *data_source;
  InterfaceCombo *interface_combo;

  //properties
  int BG_RED;
  int BG_GREEN;
  int BG_BLUE;
  int WINDOW_WIDTH;
  int WINDOW_HEIGHT;


  //various functions to set up gui
  void CreateMainWindow();
  void CreateLayout();

  //CALLBACKS
  static void CB_ChangeTab(GtkNotebook *notebook, GtkNotebookPage *page,
                           guint page_num, gpointer data);
  static gboolean CB_WindowDelete(GtkWidget *widget, GdkEvent  *event,
                                  gpointer data);
  static void CB_WindowDestroy(GtkWidget *widget, gpointer data);

  int old_page;

public:
  CEBLViewGTK(CEBLModel* model, int ac = 0, char ** av = NULL);
  ~CEBLViewGTK();

  //! start the View
  void Start();


  //! update the view of current tab
  void updateView();
  //! update the model from current tab
  void updateModel();
  //! update info_bar labels
  void updateInfoBar();

  //! GETTERS
  GtkWidget * getMainWindow() { return main_window; }
  DataSourceCombo * getDataSource() { return data_source; }
  InterfaceCombo * getInterfaceCombo() { return interface_combo; }
  StatusBar * getStatusBar() { return status_bar; }
  int getBGRED() { return BG_RED; }
  int getBGGREEN() { return BG_GREEN; }
  int getBGBLUE() { return BG_BLUE; }
  const char * getString(string name);
};



#endif

